/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.loader;

import java.util.ArrayList;
import java.util.List;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.loader.ConfigCompiler;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.parser.ConfigParser;
import org.github.gestalt.config.parser.MapConfigParser;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.ValidateOf;

public final class EnvironmentVarsLoader
implements ConfigLoader {
    private final ConfigParser parser;
    private final SentenceLexer lexer;

    public EnvironmentVarsLoader() {
        this(new PathLexer("_"), new MapConfigParser());
    }

    public EnvironmentVarsLoader(SentenceLexer lexer, ConfigParser parser) {
        this.lexer = lexer;
        this.parser = parser;
    }

    @Override
    public String name() {
        return "EnvironmentVarsLoader";
    }

    @Override
    public boolean accepts(String format) {
        return "envVars".equals(format);
    }

    @Override
    public ValidateOf<List<ConfigNodeContainer>> loadSource(ConfigSource source) throws GestaltException {
        if (!source.hasList()) {
            throw new GestaltException("Config source: " + source.name() + " does not have a list to load.");
        }
        List<Pair<String, String>> configs = source.loadList();
        ValidateOf<ConfigNode> loadedNode = ConfigCompiler.analyze(source.failOnErrors(), this.lexer, this.parser, configs);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (loadedNode.hasErrors().booleanValue()) {
            errors.addAll(loadedNode.getErrors());
        }
        if (!loadedNode.hasResults()) {
            return ValidateOf.inValid(errors);
        }
        return ValidateOf.validateOf(List.of(new ConfigNodeContainer(loadedNode.results(), source)), errors);
    }
}

