/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.loader.ConfigCompiler;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.parser.ConfigParser;
import org.github.gestalt.config.parser.MapConfigParser;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.ValidateOf;

public final class PropertyLoader
implements ConfigLoader {
    private final ConfigParser parser;
    private final SentenceLexer lexer;

    public PropertyLoader() {
        this(new PathLexer("."), new MapConfigParser());
    }

    public PropertyLoader(SentenceLexer lexer, ConfigParser parser) {
        this.lexer = lexer;
        this.parser = parser;
    }

    @Override
    public String name() {
        return "PropertyLoader";
    }

    @Override
    public boolean accepts(String format) {
        return "properties".equals(format) || "props".equals(format) || "systemProperties".equals(format);
    }

    @Override
    public ValidateOf<List<ConfigNodeContainer>> loadSource(ConfigSource source) throws GestaltException {
        Properties properties;
        block11: {
            properties = new Properties();
            if (source.hasStream()) {
                try (InputStream is = source.loadStream();){
                    properties.load(is);
                    break block11;
                }
                catch (IOException | NullPointerException e) {
                    throw new GestaltException("Exception loading source: " + source.name(), e);
                }
            }
            throw new GestaltException("Config source: " + source.name() + " does not have a stream to load.");
        }
        List<Pair<String, String>> configs = properties.entrySet().stream().map(prop -> new Pair<String, String>((String)prop.getKey(), (String)prop.getValue())).collect(Collectors.toList());
        ValidateOf<ConfigNode> loadedNode = ConfigCompiler.analyze(source.failOnErrors(), this.lexer, this.parser, configs);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (loadedNode.hasErrors().booleanValue()) {
            errors.addAll(loadedNode.getErrors());
        }
        if (!loadedNode.hasResults()) {
            return ValidateOf.inValid(errors);
        }
        return ValidateOf.validateOf(List.of(new ConfigNodeContainer(loadedNode.results(), source)), errors);
    }
}

