/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.NodeType;

public final class ArrayNode
implements ConfigNode {
    private final List<ConfigNode> values;

    public ArrayNode(List<ConfigNode> values) {
        this.values = Objects.requireNonNullElse(values, Collections.emptyList());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARRAY;
    }

    @Override
    public Optional<String> getValue() {
        return Optional.empty();
    }

    @Override
    public Optional<ConfigNode> getIndex(int index) {
        if (this.values.size() > index) {
            return Optional.ofNullable(this.values.get(index));
        }
        return Optional.empty();
    }

    public List<ConfigNode> getArray() {
        return this.values;
    }

    @Override
    public Optional<ConfigNode> getKey(String key) {
        return Optional.empty();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayNode)) {
            return false;
        }
        ArrayNode arrayNode = (ArrayNode)o;
        return Objects.equals(this.values, arrayNode.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return "ArrayNode{values=" + this.values + "}";
    }
}

