/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.ConfigNodeService;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.node.MergeNodes;
import org.github.gestalt.config.post.process.PostProcessor;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.token.ArrayToken;
import org.github.gestalt.config.token.ObjectToken;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.CollectionUtils;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public final class ConfigNodeManager
implements ConfigNodeService {
    private final List<ConfigNodeContainer> configNodes = new ArrayList<ConfigNodeContainer>();
    private final Map<Tags, ConfigNode> roots = new HashMap<Tags, ConfigNode>();

    @Override
    public ValidateOf<ConfigNode> addNode(ConfigNodeContainer newNode) throws GestaltException {
        if (newNode == null) {
            throw new GestaltException("No node provided");
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.configNodes.add(newNode);
        if (this.roots.isEmpty() || !this.roots.containsKey(newNode.getTags())) {
            this.roots.put(newNode.getTags(), newNode.getConfigNode());
        } else {
            ConfigNode rootForTokens = this.roots.get(newNode.getTags());
            ValidateOf<ConfigNode> mergedNode = MergeNodes.mergeNodes("", rootForTokens, newNode.getConfigNode());
            if (mergedNode.hasResults()) {
                this.roots.put(newNode.getTags(), mergedNode.results());
            }
            errors.addAll(mergedNode.getErrors());
        }
        errors.addAll(this.validateNode(this.roots.get(newNode.getTags())));
        errors = errors.stream().filter(CollectionUtils.distinctBy(ValidationError::description)).collect(Collectors.toList());
        return ValidateOf.validateOf(this.roots.get(newNode.getTags()), errors);
    }

    @Override
    public ValidateOf<Boolean> postProcess(List<PostProcessor> postProcessors) throws GestaltException {
        if (postProcessors == null) {
            throw new GestaltException("No postProcessors provided");
        }
        if (postProcessors.isEmpty()) {
            return ValidateOf.valid(true);
        }
        boolean ppSuccessful = true;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Map.Entry<Tags, ConfigNode> entry : this.roots.entrySet()) {
            Tags tags = entry.getKey();
            ConfigNode root = entry.getValue();
            ValidateOf<ConfigNode> results = this.postProcess("", root, postProcessors);
            errors.addAll(results.getErrors());
            if (results.hasResults()) {
                this.roots.put(tags, results.results());
                continue;
            }
            ppSuccessful = false;
            errors.add(new ValidationError.NodePostProcessingNoResults());
        }
        return ValidateOf.validateOf(Boolean.valueOf(ppSuccessful), errors);
    }

    private ValidateOf<ConfigNode> postProcess(String path, ConfigNode node, List<PostProcessor> postProcessors) {
        ConfigNode currentNode = node;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (PostProcessor it : postProcessors) {
            ValidateOf<ConfigNode> processedNode = it.process(path, currentNode);
            errors.addAll(processedNode.getErrors());
            if (processedNode.hasResults()) {
                currentNode = processedNode.results();
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, node.getClass(), "post processing"));
        }
        if (currentNode instanceof ArrayNode) {
            return this.postProcessArray(path, (ArrayNode)currentNode, postProcessors);
        }
        if (currentNode instanceof MapNode) {
            return this.postProcessMap(path, (MapNode)currentNode, postProcessors);
        }
        if (currentNode instanceof LeafNode) {
            return ValidateOf.validateOf(currentNode, errors);
        }
        return ValidateOf.inValid(new ValidationError.UnknownNodeTypePostProcess(path, node.getClass().getName()));
    }

    private ValidateOf<ConfigNode> postProcessArray(String path, ArrayNode node, List<PostProcessor> postProcessors) {
        int size = node.size();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ConfigNode[] processedNode = new ConfigNode[size];
        for (int i = 0; i < size; ++i) {
            Optional<ConfigNode> currentNodeOption = node.getIndex(i);
            if (!currentNodeOption.isPresent()) continue;
            String nextPath = PathUtil.pathForIndex(path, i);
            ValidateOf<ConfigNode> newNode = this.postProcess(nextPath, currentNodeOption.get(), postProcessors);
            errors.addAll(newNode.getErrors());
            if (newNode.hasResults()) {
                processedNode[i] = newNode.results();
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, ArrayNode.class, "post processing"));
        }
        return ValidateOf.validateOf(new ArrayNode(Arrays.asList(processedNode)), errors);
    }

    private ValidateOf<ConfigNode> postProcessMap(String path, MapNode node, List<PostProcessor> postProcessors) {
        HashMap<String, ConfigNode> processedNode = new HashMap<String, ConfigNode>();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Map.Entry<String, ConfigNode> entry : node.getMapNode().entrySet()) {
            String key = entry.getKey();
            String nextPath = PathUtil.pathForKey(path, key);
            ValidateOf<ConfigNode> newNode = this.postProcess(nextPath, entry.getValue(), postProcessors);
            errors.addAll(newNode.getErrors());
            if (newNode.hasResults()) {
                processedNode.put(key, newNode.results());
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "post processing"));
        }
        return ValidateOf.validateOf(new MapNode(processedNode), errors);
    }

    @Override
    public ValidateOf<ConfigNode> reloadNode(ConfigNodeContainer reloadNode) throws GestaltException {
        ConfigNode newRoot = null;
        List<Object> errors = new ArrayList<ValidationError>();
        if (reloadNode == null) {
            throw new GestaltException("Null value provided for Node to be reloaded");
        }
        int index = 0;
        for (ConfigNodeContainer nodePair : this.configNodes) {
            ConfigNode currentNode = nodePair.getConfigNode();
            if (nodePair.getSource().equals(reloadNode.getSource())) {
                this.configNodes.set(index, reloadNode);
                currentNode = reloadNode.getConfigNode();
            }
            if (newRoot == null) {
                newRoot = currentNode;
            } else {
                ValidateOf<ConfigNode> mergedNode = MergeNodes.mergeNodes("", newRoot, currentNode);
                errors.addAll(mergedNode.getErrors());
                if (mergedNode.hasResults()) {
                    newRoot = mergedNode.results();
                } else {
                    errors.add(new ValidationError.NoResultsFoundForNode("", "reload node"));
                }
            }
            ++index;
        }
        errors.addAll(this.validateNode(newRoot));
        errors = errors.stream().filter(CollectionUtils.distinctBy(ValidationError::description)).collect(Collectors.toList());
        this.roots.put(reloadNode.getTags(), newRoot);
        return ValidateOf.validateOf(newRoot, errors);
    }

    private List<ValidationError> validateNode(ConfigNode node) {
        return this.validateNode("", node);
    }

    private List<ValidationError> validateNode(String path, ConfigNode node) {
        if (node instanceof ArrayNode) {
            return this.validateArrayNode(path, (ArrayNode)node);
        }
        if (node instanceof MapNode) {
            return this.validateMapNode(path, (MapNode)node);
        }
        if (node instanceof LeafNode) {
            return this.validateLeafNode(path, (LeafNode)node);
        }
        return Collections.singletonList(new ValidationError.UnknownNodeType(path, node.getClass().getName()));
    }

    private List<ValidationError> validateArrayNode(String path, ArrayNode node) {
        int size = node.size();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (int i = 0; i < size; ++i) {
            if (node.getIndex(i).isEmpty()) {
                errors.add(new ValidationError.ArrayMissingIndex(i, path));
                continue;
            }
            String nextPath = PathUtil.pathForIndex(path, i);
            errors.addAll(this.validateNode(nextPath, node.getIndex(i).get()));
        }
        return errors;
    }

    private List<ValidationError> validateMapNode(String path, MapNode node) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        node.getMapNode().forEach((key, value) -> {
            if (key == null) {
                errors.add(new ValidationError.EmptyNodeNameProvided(path));
            } else if (value == null) {
                errors.add(new ValidationError.EmptyNodeValueProvided(path, (String)key));
            } else {
                String nextPath = PathUtil.pathForKey(path, key);
                errors.addAll(this.validateNode(nextPath, (ConfigNode)value));
            }
        });
        return errors;
    }

    private List<ValidationError> validateLeafNode(String path, LeafNode node) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (node == null) {
            errors.add(new ValidationError.LeafNodesIsNull(path));
        } else if (node.getValue().isEmpty()) {
            errors.add(new ValidationError.LeafNodesHaveNoValues(path));
        }
        return errors;
    }

    @Override
    public ValidateOf<ConfigNode> navigateToNode(String path, List<Token> tokens, Tags tags) {
        ValidateOf<ConfigNode> results;
        ValidateOf<ConfigNode> resultsForTags = this.navigateToNodeInternal(path, tokens, tags);
        if (Tags.of().equals(tags)) {
            results = resultsForTags;
        } else {
            ValidateOf<ConfigNode> resultsForDefault = this.navigateToNodeInternal(path, tokens, Tags.of());
            results = !resultsForTags.hasResults() ? resultsForDefault : (!resultsForDefault.hasResults() ? resultsForTags : MergeNodes.mergeNodes(path, resultsForDefault.results(), resultsForTags.results()));
        }
        return results;
    }

    private ValidateOf<ConfigNode> navigateToNodeInternal(String path, List<Token> tokens, Tags tags) {
        ConfigNode currentNode = this.roots.get(tags);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Token token : tokens) {
            ValidateOf<ConfigNode> result = this.navigateToNextNode(path, token, currentNode);
            if (result.hasErrors().booleanValue()) {
                return ValidateOf.inValid(result.getErrors());
            }
            if (result.hasResults()) {
                currentNode = result.results();
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "navigating to node"));
        }
        return ValidateOf.validateOf(currentNode, errors);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ValidateOf<ConfigNode> navigateToNextNode(String path, Token token, ConfigNode currentNode) {
        ConfigNode node = currentNode;
        if (node == null) {
            return ValidateOf.inValid(new ValidationError.NullNodeForPath(path));
        }
        if (token == null) {
            return ValidateOf.inValid(new ValidationError.NullTokenForPath(path));
        }
        if (token instanceof ArrayToken) {
            if (!(node instanceof ArrayNode)) return ValidateOf.inValid(new ValidationError.MismatchedObjectNodeForPath(path, ArrayNode.class, node.getClass()));
            Optional<ConfigNode> nextNode = node.getIndex(((ArrayToken)token).getIndex());
            if (!nextNode.isPresent()) return ValidateOf.inValid(new ValidationError.NoResultsFoundForNode(path, token.getClass(), "navigating to next node"));
            node = nextNode.get();
            return ValidateOf.valid(node);
        } else {
            if (!(token instanceof ObjectToken)) return ValidateOf.inValid(new ValidationError.UnsupportedTokenType(path, token));
            if (!(node instanceof MapNode)) return ValidateOf.inValid(new ValidationError.MismatchedObjectNodeForPath(path, MapNode.class, node.getClass()));
            Optional<ConfigNode> nextNode = node.getKey(((ObjectToken)token).getName());
            if (!nextNode.isPresent()) return ValidateOf.inValid(new ValidationError.NoResultsFoundForNode(path, token.getClass(), "navigating to next node"));
            node = nextNode.get();
        }
        return ValidateOf.valid(node);
    }

    @Override
    public ValidateOf<ConfigNode> navigateToNextNode(String path, List<Token> tokens, ConfigNode currentNode) {
        if (currentNode == null) {
            return ValidateOf.inValid(new ValidationError.NullNodeForPath(path));
        }
        if (tokens == null) {
            return ValidateOf.inValid(new ValidationError.NullTokenForPath(path));
        }
        ConfigNode node = currentNode;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Token token : tokens) {
            ValidateOf<ConfigNode> result = this.navigateToNextNode(path, token, node);
            if (result.hasErrors().booleanValue()) {
                return ValidateOf.inValid(result.getErrors());
            }
            if (result.hasResults()) {
                node = result.results();
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "navigating to node"));
        }
        return ValidateOf.validateOf(node, errors);
    }
}

