/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.Objects;
import java.util.Optional;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.NodeType;

public final class LeafNode
implements ConfigNode {
    private final String value;

    public LeafNode(String value) {
        this.value = value;
    }

    @Override
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LEAF;
    }

    @Override
    public Optional<ConfigNode> getIndex(int index) {
        return Optional.empty();
    }

    @Override
    public Optional<ConfigNode> getKey(String key) {
        return Optional.empty();
    }

    @Override
    public int size() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LeafNode)) {
            return false;
        }
        LeafNode leafNode = (LeafNode)o;
        return Objects.equals(this.value, leafNode.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "LeafNode{value='" + this.value + "'}";
    }
}

