/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.NodeType;

public final class MapNode
implements ConfigNode {
    private final Map<String, ConfigNode> mapNode;

    public MapNode(Map<String, ConfigNode> mapNode) {
        this.mapNode = Objects.requireNonNullElse(mapNode, Collections.emptyMap());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MAP;
    }

    @Override
    public Optional<String> getValue() {
        return Optional.empty();
    }

    @Override
    public Optional<ConfigNode> getIndex(int index) {
        return Optional.empty();
    }

    @Override
    public Optional<ConfigNode> getKey(String key) {
        if (this.mapNode.containsKey(key)) {
            return Optional.ofNullable(this.mapNode.get(key));
        }
        return Optional.empty();
    }

    @Override
    public int size() {
        return this.mapNode.size();
    }

    public Map<String, ConfigNode> getMapNode() {
        return this.mapNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapNode)) {
            return false;
        }
        MapNode mapNode1 = (MapNode)o;
        return Objects.equals(this.mapNode, mapNode1.mapNode);
    }

    public int hashCode() {
        return Objects.hash(this.mapNode);
    }

    public String toString() {
        return "MapNode{mapNode=" + this.mapNode + "}";
    }
}

