/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public final class MergeNodes {
    private MergeNodes() {
    }

    public static ValidateOf<ConfigNode> mergeNodes(String path, ConfigNode node1, ConfigNode node2) {
        if (node1.getClass() != node2.getClass()) {
            return ValidateOf.inValid(new ValidationError.UnableToMergeDifferentNodes(node1.getClass(), node2.getClass()));
        }
        if (node1 instanceof ArrayNode) {
            return MergeNodes.mergeArrayNodes(path, (ArrayNode)node1, (ArrayNode)node2);
        }
        if (node1 instanceof MapNode) {
            return MergeNodes.mergeMapNodes(path, (MapNode)node1, (MapNode)node2);
        }
        if (node1 instanceof LeafNode) {
            return MergeNodes.mergeLeafNodes(path, (LeafNode)node1, (LeafNode)node2);
        }
        return ValidateOf.inValid(new ValidationError.UnknownNodeType(path, node1.getClass().getName()));
    }

    private static ValidateOf<ConfigNode> mergeArrayNodes(String path, ArrayNode arrayNode1, ArrayNode arrayNode2) {
        int maxSize = Math.max(arrayNode1.size(), arrayNode2.size());
        ConfigNode[] values = new ConfigNode[maxSize];
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (int i = 0; i < maxSize; ++i) {
            Optional<ConfigNode> array1AtIndex = arrayNode1.getIndex(i);
            Optional<ConfigNode> array2AtIndex = arrayNode2.getIndex(i);
            if (array1AtIndex.isPresent() && array2AtIndex.isPresent()) {
                String nextPath = PathUtil.pathForIndex(path, i);
                ValidateOf<ConfigNode> result = MergeNodes.mergeNodes(nextPath, array1AtIndex.get(), array2AtIndex.get());
                errors.addAll(result.getErrors());
                if (result.hasResults()) {
                    values[i] = result.results();
                    continue;
                }
                errors.add(new ValidationError.NoResultsFoundForNode(path, ArrayNode.class, "merging arrays"));
                continue;
            }
            if (array1AtIndex.isPresent()) {
                values[i] = array1AtIndex.get();
                continue;
            }
            if (array2AtIndex.isPresent()) {
                values[i] = array2AtIndex.get();
                continue;
            }
            errors.add(new ValidationError.ArrayMissingIndex(i, path));
        }
        ArrayNode results = new ArrayNode(Arrays.asList(values));
        return ValidateOf.validateOf(results, errors);
    }

    private static ValidateOf<ConfigNode> mergeMapNodes(String path, MapNode mapNode1, MapNode mapNode2) {
        String key;
        HashMap<String, ConfigNode> mergedNode = new HashMap<String, ConfigNode>();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Map.Entry<String, ConfigNode> entry : mapNode1.getMapNode().entrySet()) {
            key = entry.getKey();
            if (key == null) {
                errors.add(new ValidationError.EmptyNodeNameProvided(path));
                continue;
            }
            if (entry.getValue() == null) {
                errors.add(new ValidationError.EmptyNodeValueProvided(path, key));
                continue;
            }
            if (mapNode2.getKey(key).isPresent()) {
                String nextPath = PathUtil.pathForKey(path, key);
                ValidateOf<ConfigNode> result = MergeNodes.mergeNodes(nextPath, mapNode1.getKey(key).get(), mapNode2.getKey(key).get());
                errors.addAll(result.getErrors());
                if (result.hasResults()) {
                    mergedNode.putIfAbsent(key, result.results());
                    continue;
                }
                errors.add(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "merging maps"));
                continue;
            }
            mergedNode.putIfAbsent(key, entry.getValue());
        }
        for (Map.Entry<String, ConfigNode> entry : mapNode2.getMapNode().entrySet()) {
            key = entry.getKey();
            if (key == null) {
                errors.add(new ValidationError.EmptyNodeNameProvided(path));
                continue;
            }
            if (entry.getValue() == null) {
                errors.add(new ValidationError.EmptyNodeValueProvided(path, key));
                continue;
            }
            mergedNode.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return ValidateOf.validateOf(new MapNode(mergedNode), errors);
    }

    private static ValidateOf<ConfigNode> mergeLeafNodes(String path, LeafNode node1, LeafNode node2) {
        if (node2.getValue().isPresent()) {
            return ValidateOf.valid(node2);
        }
        if (node1.getValue().isPresent()) {
            return ValidateOf.valid(node1);
        }
        return ValidateOf.inValid(new ValidationError.LeafNodesHaveNoValues(path));
    }
}

