/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.github.gestalt.config.entity.ConfigValue;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.parser.ConfigParser;
import org.github.gestalt.config.token.ArrayToken;
import org.github.gestalt.config.token.ObjectToken;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.CollectionUtils;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public final class MapConfigParser
implements ConfigParser {
    private static final System.Logger logger = System.getLogger(MapConfigParser.class.getName());

    @Override
    public ValidateOf<ConfigNode> parse(List<Pair<List<Token>, ConfigValue>> configs, boolean failOnErrors) {
        return this.buildConfigTree(configs, 0, failOnErrors);
    }

    ValidateOf<ConfigNode> buildConfigTree(List<Pair<List<Token>, ConfigValue>> tokens, int index, boolean failOnErrors) {
        if (tokens == null || tokens.isEmpty()) {
            return ValidateOf.inValid(new ValidationError.EmptyToken());
        }
        String currentPath = PathUtil.toPath(tokens.get(0).getFirst().subList(0, index));
        ArrayList<ValidationError> errorList = new ArrayList<ValidationError>();
        if (tokens.size() == 1 && tokens.get(0).getFirst().size() <= index) {
            ConfigValue configValue = tokens.get(0).getSecond();
            return ValidateOf.valid(new LeafNode(configValue.getValue()));
        }
        List<ValidationError> mismatchedPathLengthErrors = this.getMismatchedPathLengthErrors(tokens, index, currentPath);
        if (!mismatchedPathLengthErrors.isEmpty()) {
            return ValidateOf.inValid(mismatchedPathLengthErrors);
        }
        Map<Token, List<Pair<List<Token>, ConfigValue>>> tokensAtIndexGrouped = tokens.stream().collect(Collectors.groupingBy(tokenPair -> (Token)((List)tokenPair.getFirst()).get(index)));
        List<Token> tokenTypes = tokensAtIndexGrouped.keySet().stream().filter(CollectionUtils.distinctBy(Object::getClass)).collect(Collectors.toList());
        if (tokenTypes.isEmpty()) {
            errorList.add(new ValidationError.NoTokensInPath(currentPath));
        } else if (tokenTypes.size() > 1) {
            errorList.add(new ValidationError.MultipleTokenTypes(currentPath, tokenTypes));
        } else if (tokenTypes.get(0) instanceof ArrayToken) {
            errorList.addAll(this.validateArrayInvalidIndex(tokens, index, currentPath));
            errorList.addAll(this.validateArrayMissingIndex(tokens, index, currentPath));
            errorList.addAll(this.validateArrayDuplicateLeafIndex(tokensAtIndexGrouped, index, currentPath));
            errorList.addAll(this.validateArrayLeafAndNonLeaf(tokensAtIndexGrouped, index, currentPath));
        } else if (!(tokenTypes.get(0) instanceof ObjectToken)) {
            errorList.add(new ValidationError.UnknownTokenWithPath(tokenTypes.get(0), currentPath));
        }
        if (errorList.stream().anyMatch(it -> it.level().equals((Object)ValidationLevel.ERROR))) {
            return ValidateOf.inValid(errorList);
        }
        List configsValidateOf = tokens.stream().collect(Collectors.groupingBy(tokenPair -> (Token)((List)tokenPair.getFirst()).get(index))).entrySet().stream().map(entry -> new Pair<Token, ValidateOf<ConfigNode>>((Token)entry.getKey(), this.buildConfigTree((List)entry.getValue(), index + 1, failOnErrors))).collect(Collectors.toList());
        Map<ValidationLevel, List<ValidationError>> recursiveErrors = configsValidateOf.stream().map(it -> ((ValidateOf)it.getSecond()).getErrors()).flatMap(Collection::stream).collect(Collectors.groupingBy(ValidationError::level));
        if (recursiveErrors.containsKey((Object)ValidationLevel.WARN)) {
            errorList.addAll((Collection<ValidationError>)recursiveErrors.get((Object)ValidationLevel.WARN));
        }
        if (recursiveErrors.containsKey((Object)ValidationLevel.MISSING_VALUE)) {
            errorList.addAll((Collection<ValidationError>)recursiveErrors.get((Object)ValidationLevel.MISSING_VALUE));
        }
        if (recursiveErrors.containsKey((Object)ValidationLevel.ERROR)) {
            errorList.addAll((Collection<ValidationError>)recursiveErrors.get((Object)ValidationLevel.ERROR));
            if (failOnErrors) {
                return ValidateOf.inValid(errorList);
            }
        }
        List<Pair> configs = configsValidateOf.stream().filter(it -> (!failOnErrors || ((ValidateOf)it.getSecond()).hasErrors(ValidationLevel.ERROR) == false) && ((ValidateOf)it.getSecond()).hasResults()).map(it -> new Pair<Token, ConfigNode>((Token)it.getFirst(), (ConfigNode)((ValidateOf)it.getSecond()).results())).collect(Collectors.toList());
        if (configsValidateOf.isEmpty()) {
            logger.log(System.Logger.Level.WARNING, "unable to parse tokens and create config node");
        } else if (configs.isEmpty()) {
            logger.log(System.Logger.Level.WARNING, "No configs found");
        } else {
            Token token = (Token)((Pair)configs.get(0)).getFirst();
            ConfigNode result = null;
            if (token instanceof ObjectToken) {
                result = new MapNode(configs.stream().collect(Collectors.toMap(it -> ((ObjectToken)it.getFirst()).getName(), Pair::getSecond)));
            } else if (token instanceof ArrayToken) {
                OptionalInt maxArrayInt = configs.stream().map(it -> ((ArrayToken)it.getFirst()).getIndex()).mapToInt(Integer::intValue).max();
                ConfigNode[] arrayNodes = new ConfigNode[maxArrayInt.orElse(0) + 1];
                configs.forEach(config -> {
                    arrayNodes[((ArrayToken)config.getFirst()).getIndex()] = (ConfigNode)config.getSecond();
                });
                result = new ArrayNode(Arrays.asList(arrayNodes));
            }
            if (result != null) {
                return ValidateOf.validateOf(result, errorList);
            }
        }
        return ValidateOf.inValid(new ValidationError.NoResultsFoundForPath(currentPath));
    }

    private List<ValidationError> validateArrayInvalidIndex(List<Pair<List<Token>, ConfigValue>> tokens, int index, String currentPath) {
        return tokens.stream().map(token -> (ArrayToken)((List)token.getFirst()).get(index)).filter(arrayToken -> arrayToken.getIndex() < 0).map(arrayToken -> new ValidationError.ArrayInvalidIndex(arrayToken.getIndex(), currentPath)).collect(Collectors.toList());
    }

    private List<ValidationError> validateArrayMissingIndex(List<Pair<List<Token>, ConfigValue>> tokens, int index, String currentPath) {
        Map<Integer, Long> arrayIndexCounts = tokens.stream().map(token -> (ArrayToken)((List)token.getFirst()).get(index)).filter(arrayToken -> arrayToken.getIndex() >= 0).collect(Collectors.groupingBy(ArrayToken::getIndex, Collectors.counting()));
        long maxIndex = arrayIndexCounts.keySet().stream().max(Comparator.comparing(Long::valueOf)).orElse(-1).intValue();
        return IntStream.rangeClosed(0, Math.toIntExact(maxIndex)).filter(it -> !arrayIndexCounts.containsKey(it)).mapToObj(it -> new ValidationError.ArrayMissingIndex(it, currentPath)).collect(Collectors.toList());
    }

    private List<ValidationError> validateArrayLeafAndNonLeaf(Map<Token, List<Pair<List<Token>, ConfigValue>>> tokensAtIndexGrouped, int index, String currentPath) {
        List<Integer> pathSizes = tokensAtIndexGrouped.values().stream().flatMap(Collection::stream).map(it -> ((List)it.getFirst()).size()).filter(it -> it >= index + 1).distinct().collect(Collectors.toList());
        if (pathSizes.contains(index + 1) && pathSizes.size() > 1) {
            return Collections.singletonList(new ValidationError.ArrayLeafAndNotLeaf(pathSizes, currentPath));
        }
        return Collections.emptyList();
    }

    private List<ValidationError> validateArrayDuplicateLeafIndex(Map<Token, List<Pair<List<Token>, ConfigValue>>> tokensAtIndexGrouped, int index, String currentPath) {
        boolean isLeaf = tokensAtIndexGrouped.values().stream().flatMap(Collection::stream).map(it -> ((List)it.getFirst()).size()).allMatch(size -> size == index + 1);
        if (isLeaf) {
            List arrayIndexCounts = tokensAtIndexGrouped.entrySet().stream().filter(tokens -> ((List)tokens.getValue()).size() > 1).map(tokens -> (ArrayToken)tokens.getKey()).collect(Collectors.toList());
            return arrayIndexCounts.stream().map(arrayToken -> new ValidationError.ArrayDuplicateIndex(arrayToken.getIndex(), currentPath)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<ValidationError> getMismatchedPathLengthErrors(List<Pair<List<Token>, ConfigValue>> tokens, int index, String currentPath) {
        List nodesWithMismatchedPathLengths = tokens.stream().filter(tokenPair -> ((List)tokenPair.getFirst()).size() < index + 1).collect(Collectors.toList());
        ArrayList<ValidationError> errorList = new ArrayList<ValidationError>();
        if (!nodesWithMismatchedPathLengths.isEmpty()) {
            errorList.add(new ValidationError.MismatchedPathLength(currentPath));
        }
        return errorList;
    }
}

