/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.path.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.path.mapper.PathMapper;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.ValidateOf;

@ConfigPriority(value=500)
public final class DotNotationPathMapper
implements PathMapper {
    private final Pattern regex = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");

    @Override
    public ValidateOf<List<Token>> map(String path, String sentence, SentenceLexer lexer) {
        if (sentence == null) {
            return ValidateOf.inValid(new ValidationError.MappingValueNull(path, "KebabCasePathMapper"));
        }
        String[] camelCaseWords = this.regex.split(sentence);
        ArrayList tokens = new ArrayList();
        for (String word : camelCaseWords) {
            ValidateOf<List<Token>> lexedValidateOf = lexer.scan(word);
            if (lexedValidateOf.hasErrors().booleanValue()) {
                return ValidateOf.inValid(lexedValidateOf.getErrors());
            }
            if (!lexedValidateOf.hasResults()) {
                return ValidateOf.inValid(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "decoding"));
            }
            tokens.addAll(lexedValidateOf.results());
        }
        return ValidateOf.valid(tokens);
    }
}

