/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.path.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.path.mapper.PathMapper;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.ValidateOf;

@ConfigPriority(value=600)
public final class KebabCasePathMapper
implements PathMapper {
    private final Pattern regex = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");

    @Override
    public ValidateOf<List<Token>> map(String path, String sentence, SentenceLexer lexer) {
        if (sentence == null) {
            return ValidateOf.inValid(new ValidationError.MappingValueNull(path, "KebabCasePathMapper"));
        }
        String[] camelCaseWords = this.regex.split(sentence);
        String kebebCase = Arrays.stream(camelCaseWords).map(it -> it.toLowerCase(Locale.getDefault())).collect(Collectors.joining("-"));
        ValidateOf<List<Token>> lexedValidateOf = lexer.scan(kebebCase);
        if (!lexedValidateOf.hasResults()) {
            return ValidateOf.inValid(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "Kebab case path mapping"));
        }
        ArrayList tokens = new ArrayList(lexedValidateOf.results());
        return ValidateOf.validateOf(tokens, lexedValidateOf.getErrors());
    }
}

