/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform;

import java.nio.charset.Charset;
import java.util.Base64;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.post.process.transform.Transformer;
import org.github.gestalt.config.utils.ValidateOf;

public final class Base64DecoderTransformer
implements Transformer {
    @Override
    public String name() {
        return "base64Decode";
    }

    @Override
    public ValidateOf<String> process(String path, String key, String rawValue) {
        if (key != null) {
            try {
                byte[] decodedBytes = Base64.getDecoder().decode(key);
                return ValidateOf.valid(new String(decodedBytes, Charset.defaultCharset()));
            }
            catch (IllegalArgumentException e) {
                return ValidateOf.inValid(new ValidationError.InvalidBase64DecodeString(path, key, e.getMessage()));
            }
        }
        return ValidateOf.inValid(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
    }
}

