/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform;

import java.nio.charset.Charset;
import java.util.Base64;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.post.process.transform.Transformer;
import org.github.gestalt.config.utils.ValidateOf;

public final class Base64EncoderTransformer
implements Transformer {
    @Override
    public String name() {
        return "base64Encode";
    }

    @Override
    public ValidateOf<String> process(String path, String key, String rawValue) {
        if (key != null) {
            String encodedBytes = Base64.getEncoder().encodeToString(key.getBytes(Charset.defaultCharset()));
            return ValidateOf.valid(encodedBytes);
        }
        return ValidateOf.inValid(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
    }
}

