/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.post.process.transform.Transformer;
import org.github.gestalt.config.utils.ValidateOf;

public final class ClasspathTransformer
implements Transformer {
    private final int prefixLength = (this.name() + ":").length();

    @Override
    public String name() {
        return "classpath";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateOf<String> process(String path, String key, String rawValue) {
        ValidateOf<String> result;
        if (key != null) {
            InputStream is = null;
            try {
                String resource = rawValue.substring(this.prefixLength);
                is = this.getClass().getClassLoader().getResourceAsStream(resource);
                if (is == null && (is = ClasspathTransformer.class.getResourceAsStream(resource)) == null) {
                    ValidateOf<String> validateOf = ValidateOf.inValid(new ValidationError.ExceptionReadingFileDuringTransform(path, key, "Unable to load classpath resource from " + resource));
                    return validateOf;
                }
                byte[] fileBytes = is.readAllBytes();
                result = ValidateOf.valid(new String(fileBytes, Charset.defaultCharset()));
            }
            catch (IOException e) {
                result = ValidateOf.inValid(new ValidationError.ExceptionReadingFileDuringTransform(path, key, e.getMessage()));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        result = ValidateOf.inValid(new ValidationError.ExceptionReadingFileDuringTransform(path, key, e.getMessage()));
                    }
                }
            }
        } else {
            result = ValidateOf.inValid(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
        }
        return result;
    }
}

