/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform;

import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.post.process.transform.Transformer;
import org.github.gestalt.config.utils.ValidateOf;

@ConfigPriority(value=100)
public final class EnvironmentVariablesTransformer
implements Transformer {
    @Override
    public String name() {
        return "env";
    }

    @Override
    public ValidateOf<String> process(String path, String key, String rawValue) {
        if (key == null) {
            return ValidateOf.inValid(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
        }
        if (System.getenv(key) == null) {
            return ValidateOf.inValid(new ValidationError.NoEnvironmentVariableFoundPostProcess(path, key));
        }
        return ValidateOf.valid(System.getenv(key));
    }
}

