/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform;

import java.util.ArrayList;
import java.util.List;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.post.process.PostProcessorConfig;
import org.github.gestalt.config.post.process.transform.Transformer;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.ValidateOf;

@ConfigPriority(value=300)
public final class NodeTransformer
implements Transformer {
    private PostProcessorConfig config;

    @Override
    public String name() {
        return "node";
    }

    @Override
    public void applyConfig(PostProcessorConfig config) {
        this.config = config;
    }

    @Override
    public ValidateOf<String> process(String path, String key, String rawValue) {
        if (this.config == null) {
            return ValidateOf.inValid(new ValidationError.NodePostProcessingConfigMissing(path, key));
        }
        if (key == null) {
            return ValidateOf.inValid(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
        }
        String normalizedPath = this.config.getLexer().normalizeSentence(key);
        ValidateOf<List<Token>> validateOfTokens = this.config.getLexer().scan(normalizedPath);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>(validateOfTokens.getErrors());
        if (validateOfTokens.hasErrors(ValidationLevel.ERROR).booleanValue()) {
            errors.add(new ValidationError.NodePostProcessingBadTokens(path, key));
            return ValidateOf.inValid(errors);
        }
        if (!validateOfTokens.hasResults()) {
            errors.add(new ValidationError.NodePostProcessingNoResultsForTokens(path, key));
            return ValidateOf.inValid(errors);
        }
        ValidateOf<ConfigNode> validateOfConfigNode = this.config.getConfigNodeService().navigateToNode(path, validateOfTokens.results(), Tags.of());
        errors.addAll(validateOfConfigNode.getErrors());
        if (validateOfConfigNode.hasErrors(ValidationLevel.MISSING_VALUE).booleanValue()) {
            errors.add(new ValidationError.NodePostProcessingErrorsNavigatingToNode(path, key));
            return ValidateOf.inValid(errors);
        }
        if (!validateOfConfigNode.hasResults()) {
            errors.add(new ValidationError.NoResultsFoundForNode(path, key, "NodeTransformer"));
            return ValidateOf.inValid(errors);
        }
        ConfigNode node = validateOfConfigNode.results();
        if (!(node instanceof LeafNode)) {
            errors.add(new ValidationError.NodePostProcessingNodeNotLeaf(path, key));
            return ValidateOf.inValid(errors);
        }
        if (node.getValue().isEmpty()) {
            errors.add(new ValidationError.NodePostProcessingNodeLeafHasNoValue(path, key));
            return ValidateOf.inValid(errors);
        }
        return ValidateOf.valid(node.getValue().get());
    }
}

