/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform;

import java.util.Base64;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.post.process.transform.Transformer;
import org.github.gestalt.config.utils.ValidateOf;

public final class RandomTransformer
implements Transformer {
    private static final Pattern randomPattern = Pattern.compile("^(?<type>[A-Za-z]+)(\\((?<p1>[+-]?([0-9]+([.][0-9]*)?|[.][0-9]+)),?(?<p2>[+-]?([0-9]+([.][0-9]*)?|[.][0-9]+))?\\))?$");
    private final Random random;

    public RandomTransformer() {
        this.random = new Random();
    }

    public RandomTransformer(long seed) {
        this.random = new Random(seed);
    }

    private String randomChar() {
        return String.valueOf((char)(this.random.nextInt(26) + 97));
    }

    @Override
    public String name() {
        return "random";
    }

    @Override
    public ValidateOf<String> process(String path, String key, String rawValue) {
        ValidateOf<String> result;
        if (key == null) {
            return ValidateOf.inValid(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
        }
        Matcher matcher = randomPattern.matcher(key.replace(" ", ""));
        if (matcher.find()) {
            String transformName = matcher.group("type");
            String p1 = matcher.group("p1");
            String p2 = matcher.group("p2");
            try {
                switch (transformName.toLowerCase(Locale.getDefault())) {
                    case "byte": {
                        Integer parameter1 = p1 == null || p1.isEmpty() ? null : Integer.valueOf(Integer.parseInt(p1));
                        Integer parameter2 = p2 == null || p2.isEmpty() ? null : Integer.valueOf(Integer.parseInt(p2));
                        byte[] bytes = parameter1 != null ? new byte[parameter1.intValue()] : new byte[1];
                        this.random.nextBytes(bytes);
                        if (parameter2 != null) {
                            result = ValidateOf.validateOf(Base64.getEncoder().encodeToString(bytes), new ValidationError.InvalidNumberOfParametersForRandomExpression(path, key, transformName, 1));
                            break;
                        }
                        result = ValidateOf.valid(Base64.getEncoder().encodeToString(bytes));
                        break;
                    }
                    case "int": {
                        Integer parameter2;
                        Integer parameter1 = p1 == null || p1.isEmpty() ? null : Integer.valueOf(Integer.parseInt(p1));
                        Integer n = parameter2 = p2 == null || p2.isEmpty() ? null : Integer.valueOf(Integer.parseInt(p2));
                        if (parameter1 != null && parameter2 != null) {
                            result = ValidateOf.valid(String.valueOf(this.random.ints(parameter1, parameter2).findFirst().getAsInt()));
                            break;
                        }
                        if (parameter1 != null) {
                            result = ValidateOf.valid(String.valueOf(this.random.nextInt(parameter1)));
                            break;
                        }
                        result = ValidateOf.valid(String.valueOf(this.random.nextInt()));
                        break;
                    }
                    case "long": {
                        Long parameter2;
                        Long parameter1 = p1 == null || p1.isEmpty() ? null : Long.valueOf(Long.parseLong(p1));
                        Long l = parameter2 = p2 == null || p2.isEmpty() ? null : Long.valueOf(Long.parseLong(p2));
                        if (parameter1 != null && parameter2 != null) {
                            result = ValidateOf.valid(String.valueOf(this.random.longs(parameter1, parameter2).findFirst().getAsLong()));
                            break;
                        }
                        if (parameter1 != null) {
                            result = ValidateOf.valid(String.valueOf(this.random.longs(0L, parameter1).findFirst().getAsLong()));
                            break;
                        }
                        result = ValidateOf.valid(String.valueOf(this.random.nextLong()));
                        break;
                    }
                    case "float": {
                        Float parameter2;
                        Float parameter1 = p1 == null || p1.isEmpty() ? null : Float.valueOf(Float.parseFloat(p1));
                        Float f = parameter2 = p2 == null || p2.isEmpty() ? null : Float.valueOf(Float.parseFloat(p2));
                        if (parameter1 != null && parameter2 != null) {
                            result = ValidateOf.valid(String.valueOf(this.random.nextFloat() * (parameter2.floatValue() - parameter1.floatValue()) + parameter1.floatValue()));
                            break;
                        }
                        if (parameter1 != null) {
                            result = ValidateOf.valid(String.valueOf(this.random.nextFloat() * parameter1.floatValue()));
                            break;
                        }
                        result = ValidateOf.valid(String.valueOf(this.random.nextFloat()));
                        break;
                    }
                    case "double": {
                        Double parameter2;
                        Double parameter1 = p1 == null || p1.isEmpty() ? null : Double.valueOf(Double.parseDouble(p1));
                        Double d = parameter2 = p2 == null || p2.isEmpty() ? null : Double.valueOf(Double.parseDouble(p2));
                        if (parameter1 != null && parameter2 != null) {
                            result = ValidateOf.valid(String.valueOf(this.random.doubles(parameter1, parameter2).findFirst().getAsDouble()));
                            break;
                        }
                        if (parameter1 != null) {
                            result = ValidateOf.valid(String.valueOf(this.random.doubles(0.0, parameter1).findFirst().getAsDouble()));
                            break;
                        }
                        result = ValidateOf.valid(String.valueOf(this.random.nextDouble()));
                        break;
                    }
                    case "boolean": {
                        boolean value = this.random.nextBoolean();
                        String strResult = String.valueOf(value);
                        if (p1 != null || p2 != null) {
                            result = ValidateOf.validateOf(strResult, new ValidationError.InvalidNumberOfParametersForRandomExpression(path, key, transformName, 0));
                            break;
                        }
                        result = ValidateOf.valid(strResult);
                        break;
                    }
                    case "string": {
                        Integer parameter1;
                        Integer n = parameter1 = p1 == null || p1.isEmpty() ? null : Integer.valueOf(Integer.parseInt(p1));
                        if (parameter1 == null || p2 != null) {
                            result = ValidateOf.inValid(new ValidationError.InvalidNumberOfParametersForRandomExpressionError(path, key, transformName, 1));
                            break;
                        }
                        StringBuilder sb = new StringBuilder(parameter1);
                        for (int i = 0; i < parameter1; ++i) {
                            sb.append(this.randomChar());
                        }
                        result = ValidateOf.valid(sb.toString());
                        break;
                    }
                    case "char": {
                        String strResult = this.randomChar();
                        if (p1 != null || p2 != null) {
                            result = ValidateOf.validateOf(strResult, new ValidationError.InvalidNumberOfParametersForRandomExpression(path, key, transformName, 0));
                            break;
                        }
                        result = ValidateOf.valid(strResult);
                        break;
                    }
                    case "uuid": {
                        String strResult = String.valueOf(UUID.randomUUID());
                        if (p1 != null || p2 != null) {
                            result = ValidateOf.validateOf(strResult, new ValidationError.InvalidNumberOfParametersForRandomExpression(path, key, transformName, 0));
                            break;
                        }
                        result = ValidateOf.valid(strResult);
                        break;
                    }
                    default: {
                        result = ValidateOf.inValid(new ValidationError.UnsupportedRandomPostProcess(path, key));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                result = ValidateOf.inValid(new ValidationError.UnableToParseRandomParameter(path, key, transformName, p1, p2));
            }
        } else {
            result = ValidateOf.inValid(new ValidationError.UnableToParseRandomExpression(path, key));
        }
        return result;
    }
}

