/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform;

import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.post.process.transform.Transformer;
import org.github.gestalt.config.utils.ValidateOf;

@ConfigPriority(value=200)
public final class SystemPropertiesTransformer
implements Transformer {
    @Override
    public String name() {
        return "sys";
    }

    @Override
    public ValidateOf<String> process(String path, String key, String rawValue) {
        if (key == null) {
            return ValidateOf.inValid(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
        }
        if (!System.getProperties().containsKey(key)) {
            return ValidateOf.inValid(new ValidationError.NoSystemPropertyFoundPostProcess(path, key));
        }
        return ValidateOf.valid(System.getProperties().get(key).toString());
    }
}

