/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.post.process.PostProcessor;
import org.github.gestalt.config.post.process.PostProcessorConfig;
import org.github.gestalt.config.post.process.transform.Transformer;
import org.github.gestalt.config.post.process.transform.substitution.SubstitutionNode;
import org.github.gestalt.config.post.process.transform.substitution.SubstitutionTreeBuilder;
import org.github.gestalt.config.utils.CollectionUtils;
import org.github.gestalt.config.utils.ValidateOf;

public final class TransformerPostProcessor
implements PostProcessor {
    public static final String defaultSubstitutionRegex = "^((?<transform>\\w+):(?!=))?(?<key>.+?)(:=(?<default>.*))?$";
    private final Map<String, Transformer> transformers;
    private final List<Transformer> orderedDefaultTransformers;
    private Pattern pattern;
    private int maxRecursionDepth = 5;
    private SubstitutionTreeBuilder substitutionTreeBuilder;

    public TransformerPostProcessor() {
        this.transformers = new HashMap<String, Transformer>();
        ArrayList transformersList = new ArrayList();
        ServiceLoader<Transformer> loader = ServiceLoader.load(Transformer.class);
        loader.forEach(it -> {
            this.transformers.put(it.name(), (Transformer)it);
            transformersList.add(it);
        });
        this.orderedDefaultTransformers = CollectionUtils.buildOrderedConfigPriorities(transformersList, false);
        this.pattern = Pattern.compile(defaultSubstitutionRegex);
    }

    public TransformerPostProcessor(List<Transformer> transformers) {
        if (transformers == null) {
            this.transformers = Collections.emptyMap();
            this.orderedDefaultTransformers = List.of();
        } else {
            this.transformers = transformers.stream().collect(Collectors.toMap(Transformer::name, Function.identity()));
            this.orderedDefaultTransformers = CollectionUtils.buildOrderedConfigPriorities(transformers, false);
        }
        this.substitutionTreeBuilder = new SubstitutionTreeBuilder("${", "}");
        this.pattern = Pattern.compile(defaultSubstitutionRegex);
    }

    @Override
    public void applyConfig(PostProcessorConfig config) {
        this.transformers.values().forEach(it -> it.applyConfig(config));
        this.substitutionTreeBuilder = new SubstitutionTreeBuilder(config.getConfig().getSubstitutionOpeningToken(), config.getConfig().getSubstitutionClosingToken());
        this.maxRecursionDepth = config.getConfig().getMaxSubstitutionNestedDepth();
        this.pattern = Pattern.compile(defaultSubstitutionRegex);
    }

    @Override
    public ValidateOf<ConfigNode> process(String path, ConfigNode currentNode) {
        if (!(currentNode instanceof LeafNode) || currentNode.getValue().isEmpty()) {
            return ValidateOf.valid(currentNode);
        }
        String leafValue = currentNode.getValue().get();
        ValidateOf<List<SubstitutionNode>> substitutionNodes = this.substitutionTreeBuilder.build(path, leafValue);
        if (substitutionNodes.hasResults()) {
            ValidateOf<String> results = this.buildSubstitutedStringList(path, currentNode, substitutionNodes.results(), 0);
            if (results.hasResults()) {
                return ValidateOf.validateOf(new LeafNode(results.results()), results.getErrors());
            }
            return ValidateOf.inValid(results.getErrors());
        }
        return ValidateOf.inValid(substitutionNodes.getErrors());
    }

    private ValidateOf<String> buildSubstitutedStringList(String path, ConfigNode originalNode, List<SubstitutionNode> nodes, int depth) {
        if (depth > this.maxRecursionDepth) {
            return ValidateOf.inValid(new ValidationError.ExceededMaximumNestedSubstitutionDepth(path, depth, originalNode));
        }
        StringBuilder result = new StringBuilder();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (SubstitutionNode resolveNode : nodes) {
            if (resolveNode instanceof SubstitutionNode.TextNode) {
                result.append(((SubstitutionNode.TextNode)resolveNode).getText());
                continue;
            }
            if (resolveNode instanceof SubstitutionNode.TransformNode) {
                List<SubstitutionNode> nodes1 = ((SubstitutionNode.TransformNode)resolveNode).getSubNodes();
                ValidateOf<String> recursiveResults = this.buildSubstitutedStringList(path, originalNode, nodes1, depth + 1);
                errors.addAll(recursiveResults.getErrors());
                if (!recursiveResults.hasResults()) continue;
                ValidateOf<String> transformedString = this.transformString(path, recursiveResults.results());
                errors.addAll(transformedString.getErrors());
                if (!transformedString.hasResults()) continue;
                ValidateOf<List<SubstitutionNode>> substitutionNodes = this.substitutionTreeBuilder.build(path, transformedString.results());
                errors.addAll(substitutionNodes.getErrors());
                if (!substitutionNodes.hasResults()) continue;
                ValidateOf<String> nestedSub = this.buildSubstitutedStringList(path, originalNode, substitutionNodes.results(), depth + 1);
                errors.addAll(nestedSub.getErrors());
                if (!nestedSub.hasResults()) continue;
                result.append(nestedSub.results());
                continue;
            }
            errors.add(new ValidationError.NotAValidSubstitutionNode(path, resolveNode));
        }
        return ValidateOf.validateOf(result.toString(), errors);
    }

    private ValidateOf<String> transformString(String path, String input) {
        Matcher matcher = this.pattern.matcher(input);
        StringBuilder newLeafValue = new StringBuilder();
        boolean foundMatch = false;
        while (matcher.find()) {
            String transformName = matcher.group("transform");
            String key = matcher.group("key");
            String defaultValue = matcher.group("default");
            if (transformName != null) {
                if (this.transformers.containsKey(transformName)) {
                    ValidateOf<String> transformValue = this.transformers.get(transformName).process(path, key, input);
                    if (transformValue.hasResults()) {
                        newLeafValue.append(transformValue.results());
                        foundMatch = true;
                        continue;
                    }
                    if (defaultValue != null) {
                        foundMatch = true;
                        newLeafValue.append(defaultValue);
                        continue;
                    }
                    if (transformValue.hasErrors().booleanValue()) {
                        return transformValue;
                    }
                    return ValidateOf.inValid(new ValidationError.NoKeyFoundForTransform(path, transformName, key));
                }
                return ValidateOf.inValid(new ValidationError.NoMatchingTransformFound(path, transformName));
            }
            boolean foundTransformer = false;
            for (Transformer transform : this.orderedDefaultTransformers) {
                ValidateOf<String> transformValue = transform.process(path, key, input);
                if (!transformValue.hasResults()) continue;
                newLeafValue.append(transformValue.results());
                foundTransformer = true;
                foundMatch = true;
                break;
            }
            if (foundTransformer) continue;
            if (defaultValue != null) {
                foundMatch = true;
                newLeafValue.append(defaultValue);
                continue;
            }
            return ValidateOf.inValid(new ValidationError.NoMatchingDefaultTransformFound(path, key));
        }
        if (foundMatch) {
            return ValidateOf.valid(newLeafValue.toString());
        }
        return ValidateOf.inValid(new ValidationError.TransformDoesntMatchRegex(path, input));
    }
}

