/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.post.process.transform.Transformer;
import org.github.gestalt.config.utils.ValidateOf;

public final class URLDecoderTransformer
implements Transformer {
    @Override
    public String name() {
        return "urlDecode";
    }

    @Override
    public ValidateOf<String> process(String path, String key, String rawValue) {
        if (key != null) {
            try {
                return ValidateOf.valid(URLDecoder.decode(key, Charset.defaultCharset()));
            }
            catch (IllegalArgumentException e) {
                return ValidateOf.inValid(new ValidationError.InvalidBase64DecodeString(path, key, e.getMessage()));
            }
        }
        return ValidateOf.inValid(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
    }
}

