/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.post.process.transform.substitution;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.post.process.transform.substitution.SubstitutionNode;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.ValidateOf;

public final class SubstitutionTreeBuilder {
    private static final int escapeChar = 92;
    private final String openingToken;
    private final String closingToken;
    private final int firstOpeningToken;
    private final int openingTokenLength;
    private final int firstClosingToken;
    private final int closingTokenLength;
    private final Pattern patternReplaceOpen;
    private final Pattern patternReplaceClose;

    public SubstitutionTreeBuilder(String openingToken, String closingToken) {
        this.openingToken = openingToken;
        this.closingToken = closingToken;
        this.firstOpeningToken = openingToken.codePointAt(0);
        this.openingTokenLength = openingToken.length();
        this.firstClosingToken = closingToken.codePointAt(0);
        this.closingTokenLength = closingToken.length();
        this.patternReplaceOpen = Pattern.compile(Pattern.quote(Character.toString(92) + openingToken));
        this.patternReplaceClose = Pattern.compile(Pattern.quote(Character.toString(92) + closingToken));
    }

    public ValidateOf<List<SubstitutionNode>> build(String path, String value) {
        ValidateOf<Pair<SubstitutionNode, Integer>> results = this.buildInternal(path, value, 0, 0);
        List<Object> nodes = results.hasResults() && results.results().getFirst() instanceof SubstitutionNode.TransformNode ? ((SubstitutionNode.TransformNode)results.results().getFirst()).getSubNodes() : new ArrayList();
        return ValidateOf.validateOf(nodes, results.getErrors());
    }

    public ValidateOf<Pair<SubstitutionNode, Integer>> buildInternal(String path, String value, int index, int depth) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ArrayList<SubstitutionNode> nodes = new ArrayList<SubstitutionNode>();
        int lastNodeEnd = index;
        int length = value.length();
        for (int i = index; i < length; ++i) {
            String text;
            int codePointAt = value.codePointAt(i);
            if (this.firstOpeningToken == codePointAt && (i == 0 || value.codePointAt(i - 1) != 92) && value.startsWith(this.openingToken, i)) {
                if (i - lastNodeEnd > 0) {
                    text = this.getEscapedText(value, lastNodeEnd, i);
                    nodes.add(new SubstitutionNode.TextNode(text));
                }
                ValidateOf<Pair<SubstitutionNode, Integer>> nestedNodes = this.buildInternal(path, value, i += this.openingTokenLength, depth + 1);
                errors.addAll(nestedNodes.getErrors());
                if (nestedNodes.hasResults()) {
                    nodes.add(nestedNodes.results().getFirst());
                }
                i = nestedNodes.results().getSecond() - 1;
                lastNodeEnd = nestedNodes.results().getSecond();
                continue;
            }
            if (this.firstClosingToken != codePointAt || i != 0 && value.codePointAt(i - 1) == 92 || !value.startsWith(this.closingToken, i)) continue;
            if (depth == 0) {
                errors.add(new ValidationError.UnexpectedClosingTokenTransform(path, value, this.closingToken, i));
                continue;
            }
            if (lastNodeEnd != i) {
                text = this.getEscapedText(value, lastNodeEnd, i);
                nodes.add(new SubstitutionNode.TextNode(text));
            }
            return ValidateOf.validateOf(new Pair<SubstitutionNode.TransformNode, Integer>(new SubstitutionNode.TransformNode(nodes), i += this.closingTokenLength), errors);
        }
        if (depth != 0) {
            errors.add(new ValidationError.UnclosedSubstitutionTransform(path, value));
        }
        if (lastNodeEnd != length || length == 0) {
            String text = this.getEscapedText(value, lastNodeEnd, length);
            nodes.add(new SubstitutionNode.TextNode(text));
        }
        return ValidateOf.validateOf(new Pair<SubstitutionNode.TransformNode, Integer>(new SubstitutionNode.TransformNode(nodes), length), errors);
    }

    private String getEscapedText(String value, int lastNodeEnd, int i) {
        String text = value.substring(lastNodeEnd, i);
        text = this.patternReplaceOpen.matcher(text).replaceAll(Matcher.quoteReplacement(this.openingToken));
        text = this.patternReplaceClose.matcher(text).replaceAll(Matcher.quoteReplacement(this.closingToken));
        return text;
    }
}

