/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TypeCapture<T> {
    protected final Class<?> rawType;
    protected final Type type;
    protected final int hashCode;

    protected TypeCapture() {
        this.type = this.getSuperclassTypeParameter(this.getClass());
        this.rawType = this.buildRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    protected TypeCapture(Class<T> klass) {
        Objects.requireNonNull(klass);
        this.type = klass;
        this.rawType = this.buildRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    protected TypeCapture(Type klass) {
        Objects.requireNonNull(klass);
        this.type = klass;
        this.rawType = this.buildRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    public static <T> TypeCapture<T> of(Class<T> klass) {
        return new TypeCapture<T>(klass);
    }

    public static <T> TypeCapture<T> of(Type klass) {
        return new TypeCapture<T>(klass);
    }

    public boolean hasParameter() {
        return this.type instanceof ParameterizedType;
    }

    public TypeCapture<?> getFirstParameterType() {
        if (this.type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)this.type;
            return TypeCapture.of(parameterized.getActualTypeArguments()[0]);
        }
        return null;
    }

    public TypeCapture<?> getSecondParameterType() {
        ParameterizedType parameterized;
        if (this.type instanceof ParameterizedType && (parameterized = (ParameterizedType)this.type).getActualTypeArguments().length > 1) {
            return TypeCapture.of(parameterized.getActualTypeArguments()[1]);
        }
        return null;
    }

    public List<TypeCapture<?>> getParameterTypes() {
        if (this.type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)this.type;
            return Arrays.stream(parameterized.getActualTypeArguments()).map(TypeCapture::of).collect(Collectors.toList());
        }
        return null;
    }

    public Class<?> getComponentType() {
        if (this.type instanceof Class) {
            Class klass = (Class)this.type;
            return klass.getComponentType();
        }
        return null;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public String getName() {
        return this.type.getTypeName();
    }

    public boolean isAssignableFrom(Type classType) {
        return this.rawType.isAssignableFrom(this.buildRawType(classType));
    }

    public boolean isArray() {
        return this.getRawType().isArray();
    }

    public boolean isEnum() {
        return this.getRawType().isEnum();
    }

    public boolean isInterface() {
        return this.getRawType().isInterface();
    }

    public Annotation[] getAnnotations() {
        return this.getRawType().getAnnotations();
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        return this.getRawType().getAnnotationsByType(annotationClass);
    }

    protected Type getSuperclassTypeParameter(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        return parameterized.getActualTypeArguments()[0];
    }

    protected Class<?> buildRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(this.buildRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable || type instanceof WildcardType) {
            return Object.class;
        }
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + type.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeCapture)) {
            return false;
        }
        TypeCapture that = (TypeCapture)o;
        return this.hashCode == that.hashCode && this.rawType.equals(that.rawType) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.rawType, this.type, this.hashCode);
    }

    public String toString() {
        return "TypeCapture{rawType=" + this.rawType + ", type=" + this.type + "}";
    }
}

