/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.reload;

import java.util.ArrayList;
import java.util.List;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.reload.ConfigReloadListener;
import org.github.gestalt.config.source.ConfigSource;

public class ConfigReloadStrategy {
    protected final List<ConfigReloadListener> listeners = new ArrayList<ConfigReloadListener>();
    protected final ConfigSource source;

    protected ConfigReloadStrategy(ConfigSource source) {
        this.source = source;
    }

    public void registerListener(ConfigReloadListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConfigReloadListener listener) {
        this.listeners.remove(listener);
    }

    protected void reload() throws GestaltException {
        ArrayList<GestaltException> exceptions = new ArrayList<GestaltException>();
        for (ConfigReloadListener it : this.listeners) {
            try {
                it.reload(this.source);
            }
            catch (GestaltException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new GestaltException(exceptions);
        }
    }
}

