/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.reload;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.github.gestalt.config.exceptions.GestaltConfigurationException;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.reload.ConfigReloadListener;
import org.github.gestalt.config.reload.ConfigReloadStrategy;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.FileConfigSource;

public final class FileChangeReloadStrategy
extends ConfigReloadStrategy {
    private static final System.Logger logger = System.getLogger(FileChangeReloadStrategy.class.getName());
    private final Path path;
    private final WatchService watcher;
    private final ExecutorService executor;
    private volatile boolean isWatching = false;

    public FileChangeReloadStrategy(ConfigSource source) throws GestaltConfigurationException {
        this(source, Executors.newSingleThreadExecutor());
    }

    public FileChangeReloadStrategy(ConfigSource source, ExecutorService executor) throws GestaltConfigurationException {
        super(source);
        this.executor = executor;
        if (!(source instanceof FileConfigSource)) {
            throw new GestaltConfigurationException("Unable to add a File Change reload strategy to a non file source " + source);
        }
        this.path = ((FileConfigSource)source).getPath();
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.path.toAbsolutePath().getParent().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            throw new GestaltConfigurationException("unable to create a watch service on file " + this.path);
        }
    }

    @Override
    public void registerListener(ConfigReloadListener listener) {
        super.registerListener(listener);
        if (!this.isWatching) {
            this.isWatching = true;
            this.executor.execute(this::fileWatchTask);
        }
    }

    @Override
    public void removeListener(ConfigReloadListener listener) {
        super.removeListener(listener);
        if (this.listeners.isEmpty() && this.isWatching) {
            this.isWatching = false;
        }
    }

    private void fileWatchTask() {
        try {
            while (this.isWatching) {
                WatchKey key = this.watcher.take();
                try {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (event.kind() == StandardWatchEventKinds.OVERFLOW) break;
                        Path fileName = (Path)event.context();
                        ArrayList<Path> linkChain = new ArrayList<Path>();
                        Path currentPath = this.path;
                        linkChain.add(currentPath);
                        while (Files.isSymbolicLink(currentPath)) {
                            Path nextSymLink = Files.readSymbolicLink(currentPath).iterator().next();
                            currentPath = currentPath.getParent().resolve(nextSymLink);
                            linkChain.add(currentPath);
                        }
                        Path parentFile = this.path.getParent().resolve(fileName);
                        if (!linkChain.contains(parentFile)) continue;
                        this.reload();
                    }
                    boolean valid = key.reset();
                    if (valid) continue;
                    break;
                }
                catch (IOException | GestaltException e) {
                    logger.log(System.Logger.Level.ERROR, "Ignoring exception while watching for file " + this.path + ", message: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            logger.log(System.Logger.Level.ERROR, "Received a InterruptedException while watching file " + this.path.toString() + ", message: " + e.getMessage(), (Throwable)e);
        }
    }
}

