/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.reload;

import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.reload.ConfigReloadStrategy;
import org.github.gestalt.config.source.ConfigSource;

public final class TimedConfigReloadStrategy
extends ConfigReloadStrategy {
    private static final System.Logger logger = System.getLogger(TimedConfigReloadStrategy.class.getName());
    private final Timer timer = new Timer();
    private final Duration reloadDelay;

    public TimedConfigReloadStrategy(ConfigSource source, Duration reloadDelay) {
        super(source);
        this.reloadDelay = reloadDelay;
        this.startTimer();
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    TimedConfigReloadStrategy.this.reload();
                }
                catch (GestaltException e) {
                    logger.log(System.Logger.Level.ERROR, "Exception reloading source " + TimedConfigReloadStrategy.this.source.name() + ", exception " + e, (Throwable)e);
                }
            }
        }, this.reloadDelay.toMillis(), this.reloadDelay.toMillis());
    }
}

