/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;

public final class ClassPathConfigSource
implements ConfigSource {
    private final String resource;
    private final UUID id = UUID.randomUUID();
    private final Tags tags;

    public ClassPathConfigSource(String resource) throws GestaltException {
        this(resource, Tags.of());
    }

    public ClassPathConfigSource(String resource, Tags tags) throws GestaltException {
        this.resource = resource;
        if (resource == null) {
            throw new GestaltException("Class path resource cannot be null");
        }
        this.tags = tags;
    }

    @Override
    public boolean hasStream() {
        return true;
    }

    @Override
    public InputStream loadStream() throws GestaltException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.resource);
        if (is == null && (is = ClassPathConfigSource.class.getResourceAsStream(this.resource)) == null) {
            throw new GestaltException("Unable to load classpath resource from " + this.resource);
        }
        return is;
    }

    @Override
    public boolean hasList() {
        return false;
    }

    @Override
    public List<Pair<String, String>> loadList() throws GestaltException {
        throw new GestaltException("Unsupported operation loadList on an ClassPathConfigSource");
    }

    @Override
    public String format() {
        return this.format(this.resource);
    }

    private String format(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    @Override
    public String name() {
        return "Class Path resource: " + this.resource;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassPathConfigSource)) {
            return false;
        }
        ClassPathConfigSource that = (ClassPathConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

