/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.SystemWrapper;

public final class EnvironmentConfigSource
implements ConfigSource {
    public static final String ENV_VARS = "envVars";
    private final UUID id = UUID.randomUUID();
    private final boolean failOnErrors;
    private final String prefix;
    private final boolean removePrefix;
    private final Tags tags;

    public EnvironmentConfigSource() {
        this("", false, false, Tags.of());
    }

    public EnvironmentConfigSource(boolean failOnErrors) {
        this("", false, failOnErrors, Tags.of());
    }

    public EnvironmentConfigSource(String prefix, boolean removePrefix) {
        this(prefix, removePrefix, false, Tags.of());
    }

    public EnvironmentConfigSource(String prefix) {
        this(prefix, true, false, Tags.of());
    }

    public EnvironmentConfigSource(String prefix, boolean removePrefix, boolean failOnErrors, Tags tags) {
        this.failOnErrors = failOnErrors;
        this.prefix = prefix;
        this.removePrefix = removePrefix;
        this.tags = tags;
    }

    @Override
    public boolean failOnErrors() {
        return this.failOnErrors;
    }

    @Override
    public boolean hasStream() {
        return false;
    }

    @Override
    public InputStream loadStream() throws GestaltException {
        throw new GestaltException("Unsupported operation load stream on an EnvironmentConfigSource");
    }

    @Override
    public boolean hasList() {
        return true;
    }

    @Override
    public List<Pair<String, String>> loadList() {
        return SystemWrapper.getEnvVars().entrySet().stream().filter(envVar -> ((String)envVar.getKey()).startsWith(this.prefix)).map(envVar -> {
            String key = (String)envVar.getKey();
            if (this.removePrefix && ((key = key.substring(this.prefix.length())).startsWith("_") || key.startsWith("."))) {
                key = key.substring(1);
            }
            return new Pair<String, String>(key, (String)envVar.getValue());
        }).collect(Collectors.toList());
    }

    @Override
    public String format() {
        return ENV_VARS;
    }

    @Override
    public String name() {
        return ENV_VARS;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnvironmentConfigSource)) {
            return false;
        }
        EnvironmentConfigSource that = (EnvironmentConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

