/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;

public final class FileConfigSource
implements ConfigSource {
    private static final System.Logger logger = System.getLogger(FileConfigSource.class.getName());
    private final Path path;
    private final UUID id = UUID.randomUUID();
    private final Tags tags;

    public FileConfigSource(File file) throws GestaltException {
        this(Objects.requireNonNull(file, "file can not be null").toPath(), Tags.of());
    }

    public FileConfigSource(File file, Tags tags) throws GestaltException {
        this(Objects.requireNonNull(file, "file can not be null").toPath(), tags);
    }

    public FileConfigSource(Path path) throws GestaltException {
        this(path, Tags.of());
    }

    public FileConfigSource(Path path, Tags tags) throws GestaltException {
        this.path = this.validatePath(path);
        this.tags = tags;
    }

    private Path validatePath(Path path) throws GestaltException {
        Objects.requireNonNull(path, "Path can not be null");
        if (!Files.exists(path, new LinkOption[0])) {
            throw new GestaltException("File does not exist from path: " + path);
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new GestaltException("Path is not a regular file: " + path);
        }
        if (!Files.isReadable(path)) {
            throw new GestaltException("Path is not a readable: " + path);
        }
        if (this.format(path).isEmpty()) {
            logger.log(System.Logger.Level.DEBUG, "Unable to find a format for the file: {0}", path);
        }
        return path;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean hasStream() {
        return true;
    }

    @Override
    public InputStream loadStream() throws GestaltException {
        try {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GestaltException("Unable to load file from path " + this.path, e);
        }
    }

    @Override
    public boolean hasList() {
        return false;
    }

    @Override
    public List<Pair<String, String>> loadList() throws GestaltException {
        throw new GestaltException("Unsupported operation loadList on an FileConfigSource");
    }

    @Override
    public String format() {
        return this.format(this.path);
    }

    private String format(Path path) {
        String fileName = path.getFileName().toString();
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    @Override
    public String name() {
        return "File source: " + this.path.toString();
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileConfigSource)) {
            return false;
        }
        FileConfigSource that = (FileConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

