/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;

public final class StringConfigSource
implements ConfigSource {
    private final String config;
    private final String format;
    private final UUID id = UUID.randomUUID();
    private final Tags tags;

    public StringConfigSource(String config, String format) throws GestaltException {
        this(config, format, Tags.of());
    }

    public StringConfigSource(String config, String format, Tags tags) throws GestaltException {
        this.config = config;
        if (config == null) {
            throw new GestaltException("The string provided was null");
        }
        this.format = format;
        if (format == null) {
            throw new GestaltException("The string format provided was null");
        }
        this.tags = tags;
    }

    @Override
    public boolean hasStream() {
        return true;
    }

    @Override
    public InputStream loadStream() {
        return new ByteArrayInputStream(this.config.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean hasList() {
        return false;
    }

    @Override
    public List<Pair<String, String>> loadList() throws GestaltException {
        throw new GestaltException("Unsupported operation loadList on an StringConfigSource");
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public String name() {
        return "String format: " + this.format;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringConfigSource)) {
            return false;
        }
        StringConfigSource that = (StringConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

