/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;

public final class URLConfigSource
implements ConfigSource {
    private final String sourceURL;
    private final URL source;
    private final UUID id = UUID.randomUUID();
    private final Tags tags;

    public URLConfigSource(String sourceURL) throws GestaltException {
        this(sourceURL, Tags.of());
    }

    public URLConfigSource(String sourceURL, Tags tags) throws GestaltException {
        this.sourceURL = sourceURL;
        if (this.sourceURL == null) {
            throw new GestaltException("The url string provided was null");
        }
        try {
            this.source = new URL(this.sourceURL);
        }
        catch (MalformedURLException e) {
            throw new GestaltException("Exception creating URL " + sourceURL + ", with error: " + e.getMessage(), e);
        }
        this.tags = tags;
    }

    @Override
    public boolean hasStream() {
        return true;
    }

    @Override
    public InputStream loadStream() throws GestaltException {
        try {
            return this.source.openStream();
        }
        catch (IOException e) {
            throw new GestaltException("Exception opening stream to " + this.sourceURL, e);
        }
    }

    @Override
    public boolean hasList() {
        return false;
    }

    @Override
    public List<Pair<String, String>> loadList() throws GestaltException {
        throw new GestaltException("Unsupported operation loadList on an URLConfigSource");
    }

    @Override
    public String name() {
        return "URL format: " + this.sourceURL;
    }

    @Override
    public String format() {
        return this.format(this.sourceURL);
    }

    private String format(String url) {
        int index = url.lastIndexOf(46);
        if (index > 0) {
            return url.substring(index + 1);
        }
        return "";
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof URLConfigSource)) {
            return false;
        }
        URLConfigSource that = (URLConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

