/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.tag;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.tag.Tag;

public final class Tags {
    private static final Tags defaultTags = new Tags(Set.of());
    private final Set<Tag> tags;

    private Tags(Set<Tag> tags) {
        this.tags = new HashSet<Tag>(tags);
    }

    public static Tags of() {
        return defaultTags;
    }

    public static Tags of(List<Tag> tags) {
        return new Tags(new HashSet<Tag>(tags));
    }

    public static Tags of(Tag ... tag) {
        return new Tags(Arrays.stream(tag).collect(Collectors.toSet()));
    }

    public static Tags of(String ... tagsVarg) throws GestaltException {
        if (tagsVarg.length % 2 != 0) {
            throw new GestaltException("Tags must have come in pairs, received odd number of tags: " + tagsVarg.length);
        }
        int capacity = Math.floorDiv(tagsVarg.length, 2);
        HashSet<Tag> tags = new HashSet<Tag>(capacity);
        for (int i = 0; i < tagsVarg.length; i += 2) {
            tags.add(Tag.of(tagsVarg[i], tagsVarg[i + 1]));
        }
        return new Tags(tags);
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public static Tags profile(String value) {
        return Tags.of(Tag.of("profile", value));
    }

    public static Tags profiles(String ... value) {
        if (value.length == 1) {
            return Tags.profile(value[0]);
        }
        return Tags.of(Arrays.stream(value).map(it -> Tag.of("profile", it)).collect(Collectors.toList()));
    }

    public static Tags environment(String value) {
        return Tags.of(Tag.of("environment", value));
    }

    public static Tags environments(String ... value) {
        if (value.length == 1) {
            return Tags.environment(value[0]);
        }
        return Tags.of(Arrays.stream(value).map(it -> Tag.of("environment", it)).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tags)) {
            return false;
        }
        Tags tags1 = (Tags)o;
        return this.tags.equals(tags1.tags);
    }

    public int hashCode() {
        return Objects.hash(this.tags);
    }
}

