/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.utils;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.github.gestalt.config.annotations.ConfigPriority;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Predicate<T> distinctBy(Function<? super T, Object> valueExtractor) {
        ConcurrentHashMap distinctMap = new ConcurrentHashMap();
        return t -> distinctMap.putIfAbsent(valueExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static <T> List<T> buildOrderedConfigPriorities(List<T> configPriorityList, boolean ascending) {
        return configPriorityList.stream().filter(it -> it.getClass().isAnnotationPresent(ConfigPriority.class)).sorted((t1, t2) -> {
            ConfigPriority cp1 = t1.getClass().getAnnotation(ConfigPriority.class);
            int cp1Value = 0;
            if (cp1 != null) {
                cp1Value = cp1.value();
            }
            ConfigPriority cp2 = t2.getClass().getAnnotation(ConfigPriority.class);
            int cp2Value = 0;
            if (cp2 != null) {
                cp2Value = cp2.value();
            }
            return ascending ? cp1Value - cp2Value : cp2Value - cp1Value;
        }).collect(Collectors.toList());
    }
}

