/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.utils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;

public final class ValidateOf<T> {
    private final T results;
    private final List<ValidationError> errors;

    private ValidateOf(T results, List<ValidationError> errors) {
        this.results = results;
        this.errors = Objects.requireNonNullElse(errors, Collections.emptyList());
    }

    public static <T> ValidateOf<T> valid(T answer) {
        return new ValidateOf<T>(answer, Collections.emptyList());
    }

    public static <T> ValidateOf<T> inValid(List<ValidationError> errors) {
        return new ValidateOf<Object>(null, errors);
    }

    public static <T> ValidateOf<T> inValid(ValidationError errors) {
        return new ValidateOf<Object>(null, Collections.singletonList(errors));
    }

    public static <T> ValidateOf<T> validateOf(T answer, ValidationError errors) {
        return new ValidateOf<T>(answer, List.of(errors));
    }

    public static <T> ValidateOf<T> validateOf(T answer, List<ValidationError> errors) {
        return new ValidateOf<T>(answer, errors);
    }

    public Boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Boolean hasErrors(ValidationLevel level) {
        return this.errors.stream().anyMatch(it -> it.level().equals((Object)level));
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public List<ValidationError> getErrors(ValidationLevel level) {
        return this.errors.stream().filter(it -> it.level().equals((Object)level)).collect(Collectors.toList());
    }

    public boolean hasResults() {
        return this.results != null;
    }

    public T results() {
        return this.results;
    }
}

