module org.github.gestalt.core {
    exports org.github.gestalt.config;
    exports org.github.gestalt.config.annotations;
    exports org.github.gestalt.config.builder;
    exports org.github.gestalt.config.decoder;
    exports org.github.gestalt.config.entity;
    exports org.github.gestalt.config.exceptions;
    exports org.github.gestalt.config.lexer;
    exports org.github.gestalt.config.loader;
    exports org.github.gestalt.config.metadata;
    exports org.github.gestalt.config.node;
    exports org.github.gestalt.config.node.factory;
    exports org.github.gestalt.config.observations;
    exports org.github.gestalt.config.parser;
    exports org.github.gestalt.config.path.mapper;
    exports org.github.gestalt.config.processor.config;
    exports org.github.gestalt.config.processor.config.annotation;
    exports org.github.gestalt.config.processor.config.include;
    exports org.github.gestalt.config.processor.config.transform;
    exports org.github.gestalt.config.processor.config.transform.substitution;
    exports org.github.gestalt.config.processor.result;
    exports org.github.gestalt.config.processor.result.validation;
    exports org.github.gestalt.config.reflect;
    exports org.github.gestalt.config.reload;
    exports org.github.gestalt.config.secret.rules;
    exports org.github.gestalt.config.security.encrypted;
    exports org.github.gestalt.config.security.temporary;
    exports org.github.gestalt.config.source;
    exports org.github.gestalt.config.tag;
    exports org.github.gestalt.config.token;
    exports org.github.gestalt.config.utils;

    provides Decoder with ArrayDecoder, BigDecimalDecoder, BigIntegerDecoder, BooleanDecoder, ByteDecoder, CharDecoder, DateDecoder, DoubleDecoder, DurationDecoder, EnumDecoder, FileDecoder, FloatDecoder, InstantDecoder, IntegerDecoder, ListDecoder, LocalDateDecoder, LocalDateTimeDecoder, LongDecoder, MapDecoder, ObjectDecoder, OptionalDecoder, OptionalDoubleDecoder, OptionalIntDecoder, OptionalLongDecoder, PathDecoder, PatternDecoder, ProxyDecoder, RecordDecoder, SetDecoder, ShortDecoder, StringDecoder, UUIDDecoder;
    provides ConfigLoader with EnvironmentVarsLoader, MapConfigLoader, PropertyLoader;
    provides PathMapper with DotNotationPathMapper, KebabCasePathMapper, StandardPathMapper, SnakeCasePathMapper;
    provides ConfigNodeProcessor with LoadtimeStringSubstitutionConfigNodeProcessor, EncryptedSecretConfigNodeProcessor, TemporarySecretConfigNodeProcessor, IncludeConfigNodeProcessor, AnnotationConfigNodeProcessor, RunTimeMetadataConfigNodeProcessor;
    provides RunTimeConfigNodeProcessor with RunTimeStringSubstitutionConfigNodeProcessor;
    provides Transformer with Base64DecoderTransformer, Base64EncoderTransformer, ClasspathTransformer, Distribution100Transformer, EnvironmentVariablesTransformer, EnvironmentVariablesTransformerOld, FileTransformer, SystemPropertiesTransformer, NodeTransformer, RandomTransformer, URLDecoderTransformer, URLEncoderTransformer;
    provides ConfigNodeFactory with ClassPathConfigNodeFactory, ConfigNodeImportFactory, EnvVarsConfigNodeFactory, FileConfigNodeFactory, KubernetesSecretConfigNodeFactory, SystemConfigNodeFactory, UrlConfigNodeFactory;
    provides AnnotationMetadataTransform with EncryptionAnnotationMetadataTransform, TemporaryAnnotationMetadataTransform, NoCacheAnnotationMetadataTransform, SecretAnnotationMetadataTransform;

}

