/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.github.gestalt.config.Gestalt;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.metadata.IsNoCacheMetadata;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.TagMergingStrategy;
import org.github.gestalt.config.observations.ObservationService;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.reload.CoreReloadListener;
import org.github.gestalt.config.secret.rules.SecretChecker;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.Triple;

public class GestaltCache
implements Gestalt,
CoreReloadListener {
    private final Gestalt delegate;
    private final Map<Triple<String, TypeCapture<?>, Tags>, Object> cache = Collections.synchronizedMap(new HashMap());
    private final Map<Triple<String, TypeCapture<?>, Tags>, GResultOf<Object>> cacheResultsOf = Collections.synchronizedMap(new HashMap());
    private final Tags defaultTags;
    private final ObservationService observationService;
    private final GestaltConfig gestaltConfig;
    private final TagMergingStrategy tagMergingStrategy;
    private final List<SecretChecker> nonCacheableSecrets;

    public GestaltCache(Gestalt delegate, Tags defaultTags, ObservationService observationService, GestaltConfig gestaltConfig, TagMergingStrategy tagMergingStrategy, List<SecretChecker> nonCacheableSecrets) {
        Objects.requireNonNull(tagMergingStrategy);
        this.delegate = delegate;
        this.defaultTags = defaultTags;
        this.observationService = observationService;
        this.gestaltConfig = gestaltConfig;
        this.tagMergingStrategy = tagMergingStrategy;
        this.nonCacheableSecrets = nonCacheableSecrets;
    }

    @Override
    public void loadConfigs() throws GestaltException {
        this.delegate.loadConfigs();
        this.cache.clear();
    }

    @Override
    public <T> T getConfig(String path, Class<T> klass) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfigInternal(path, typeCapture, null);
    }

    @Override
    public <T> T getConfig(String path, Class<T> klass, Tags tags) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfigInternal(path, typeCapture, tags);
    }

    @Override
    public <T> T getConfig(String path, TypeCapture<T> klass) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        return this.getConfigInternal(path, klass, null);
    }

    @Override
    public <T> T getConfig(String path, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigInternal(path, klass, tags);
    }

    @Override
    public <T> GResultOf<T> getConfigResult(String path, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigInternalResult(path, klass, tags);
    }

    private <T> T getConfigInternal(String path, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Tags resolvedTags = this.tagMergingStrategy.mergeTags(tags, this.defaultTags);
        Triple key = new Triple(path, klass, resolvedTags);
        if (this.cache.get(key) != null) {
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                this.observationService.recordObservation("cache.hit", 1.0, Tags.of());
            }
            return (T)this.cache.get(key);
        }
        GResultOf<T> result = this.delegate.getConfigResult(path, klass, resolvedTags);
        this.updateCache(path, key, result);
        return result != null ? (T)result.results() : null;
    }

    private <T> GResultOf<T> getConfigInternalResult(String path, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Tags resolvedTags = this.tagMergingStrategy.mergeTags(tags, this.defaultTags);
        Triple key = new Triple(path, klass, resolvedTags);
        if (this.cacheResultsOf.get(key) != null && this.cacheResultsOf.get(key).hasResults()) {
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                this.observationService.recordObservation("cache.hit", 1.0, Tags.of());
            }
            return this.cacheResultsOf.get(key);
        }
        GResultOf<T> result = this.delegate.getConfigResult(path, klass, resolvedTags);
        this.updateCacheResults(path, key, result);
        return result;
    }

    private <T> void updateCache(String path, Triple<String, TypeCapture<?>, Tags> key, GResultOf<T> result) {
        if (this.shouldCacheValue(path, result != null ? result.getMetadata() : Map.of())) {
            this.cache.put(key, result != null ? (Object)result.results() : null);
        }
    }

    private <T> void updateCacheResults(String path, Triple<String, TypeCapture<?>, Tags> key, GResultOf<T> result) {
        if (this.shouldCacheValue(path, result != null ? result.getMetadata() : Map.of())) {
            this.cacheResultsOf.put(key, result);
        }
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, Class<T> klass) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfigInternal(path, defaultVal, typeCapture, null);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, Class<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfigInternal(path, defaultVal, typeCapture, tags);
    }

    @Override
    public <T> GResultOf<T> getConfigResult(String path, T defaultVal, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigInternalResult(path, defaultVal, klass, tags);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, TypeCapture<T> klass) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        return this.getConfigInternal(path, defaultVal, klass, null);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigInternal(path, defaultVal, klass, tags);
    }

    private <T> T getConfigInternal(String path, T defaultVal, TypeCapture<T> klass, Tags tags) {
        Tags resolvedTags = this.tagMergingStrategy.mergeTags(tags, this.defaultTags);
        Triple key = new Triple(path, klass, resolvedTags);
        if (this.cache.containsKey(key)) {
            Object result = this.cache.get(key);
            if (result == null) {
                result = defaultVal;
            }
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                this.observationService.recordObservation("cache.hit", 1.0, Tags.of());
            }
            return (T)result;
        }
        Optional<GResultOf<T>> result = this.delegate.getConfigOptionalResult(path, klass, resolvedTags);
        this.updateCache(path, key, result.orElse(null));
        if (result.isPresent() && result.get().hasResults()) {
            return result.get().results();
        }
        return defaultVal;
    }

    private <T> GResultOf<T> getConfigInternalResult(String path, T defaultVal, TypeCapture<T> klass, Tags tags) {
        Tags resolvedTags = this.tagMergingStrategy.mergeTags(tags, this.defaultTags);
        Triple key = new Triple(path, klass, resolvedTags);
        if (this.cacheResultsOf.containsKey(key)) {
            GResultOf<Object> result = this.cacheResultsOf.get(key);
            if (result == null || !result.hasResults()) {
                result = GResultOf.result(defaultVal, true);
            }
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                this.observationService.recordObservation("cache.hit", 1.0, Tags.of());
            }
            return result;
        }
        Optional<GResultOf<T>> result = this.delegate.getConfigOptionalResult(path, klass, resolvedTags);
        this.updateCacheResults(path, key, result.orElse(null));
        if (result.isPresent() && result.get().hasResults()) {
            return result.get();
        }
        return GResultOf.result(defaultVal);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, Class<T> klass) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfigOptionalInternal(path, typeCapture, null);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, Class<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfigOptionalInternal(path, typeCapture, tags);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, TypeCapture<T> klass) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        return this.getConfigOptionalInternal(path, klass, null);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigOptionalInternal(path, klass, tags);
    }

    @Override
    public <T> Optional<GResultOf<T>> getConfigOptionalResult(String path, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigOptionalInternalResult(path, klass, tags);
    }

    public <T> Optional<T> getConfigOptionalInternal(String path, TypeCapture<T> klass, Tags tags) {
        Tags resolvedTags = this.tagMergingStrategy.mergeTags(tags, this.defaultTags);
        Triple key = new Triple(path, klass, resolvedTags);
        if (this.cache.containsKey(key)) {
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                this.observationService.recordObservation("cache.hit", 1.0, Tags.of());
            }
            Object result = this.cache.get(key);
            return Optional.ofNullable(result);
        }
        Optional<GResultOf<Object>> resultOptional = this.delegate.getConfigOptionalResult(path, klass, resolvedTags);
        GResultOf result = resultOptional.orElse(null);
        this.updateCache(path, key, result);
        return Optional.ofNullable(result != null ? (Object)result.results() : null);
    }

    public <T> Optional<GResultOf<T>> getConfigOptionalInternalResult(String path, TypeCapture<T> klass, Tags tags) {
        Tags resolvedTags = this.tagMergingStrategy.mergeTags(tags, this.defaultTags);
        Triple key = new Triple(path, klass, resolvedTags);
        if (this.cacheResultsOf.containsKey(key)) {
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                this.observationService.recordObservation("cache.hit", 1.0, Tags.of());
            }
            GResultOf<Object> result = this.cacheResultsOf.get(key);
            return Optional.ofNullable(result);
        }
        Optional<GResultOf<Object>> resultOptional = this.delegate.getConfigOptionalResult(path, klass, resolvedTags);
        GResultOf result = resultOptional.orElse(null);
        this.updateCacheResults(path, key, result);
        return Optional.ofNullable(result);
    }

    private boolean shouldCacheValue(String path, Map<String, List<MetaDataValue<?>>> metadata) {
        boolean notIsSecret = this.nonCacheableSecrets.stream().noneMatch(it -> it.isSecret(path));
        boolean noCacheMetadata = metadata.containsKey(IsNoCacheMetadata.NO_CACHE) && metadata.get(IsNoCacheMetadata.NO_CACHE).stream().map(it -> it instanceof IsNoCacheMetadata && (Boolean)((IsNoCacheMetadata)it).getMetadata() != false).filter(it -> it).findFirst().orElse(false) != false;
        return notIsSecret && !noCacheMetadata;
    }

    @Override
    public void registerListener(CoreReloadListener listener) {
        this.delegate.registerListener(listener);
    }

    @Override
    public void removeListener(CoreReloadListener listener) {
        this.delegate.removeListener(listener);
    }

    @Override
    public String debugPrint(Tags tags) {
        return this.delegate.debugPrint(tags);
    }

    @Override
    public String debugPrint() {
        return this.delegate.debugPrint();
    }

    @Override
    public void reload() {
        this.cache.clear();
    }

    public Gestalt getDelegate() {
        return this.delegate;
    }

    @Override
    public DecoderService getDecoderService() {
        return this.delegate.getDecoderService();
    }

    @Override
    public DecoderContext getDecoderContext() {
        return this.delegate.getDecoderContext();
    }
}

