/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.github.gestalt.config.Gestalt;
import org.github.gestalt.config.annotations.ConfigPrefix;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.exceptions.GestaltConfigurationException;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.ConfigNodeService;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.TagMergingStrategy;
import org.github.gestalt.config.observations.ObservationMarker;
import org.github.gestalt.config.observations.ObservationService;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorService;
import org.github.gestalt.config.processor.result.ResultsProcessorService;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.reload.ConfigReloadListener;
import org.github.gestalt.config.reload.CoreReloadListener;
import org.github.gestalt.config.reload.CoreReloadListenersContainer;
import org.github.gestalt.config.secret.rules.SecretConcealer;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.tag.Tag;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.ClassUtils;
import org.github.gestalt.config.utils.ErrorsUtil;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.Pair;

public class GestaltCore
implements Gestalt,
ConfigReloadListener {
    private static final System.Logger logger = System.getLogger(GestaltCore.class.getName());
    private final ConfigLoaderService configLoaderService;
    private final List<ConfigSourcePackage> sourcePackages;
    private final DecoderService decoderService;
    private final SentenceLexer sentenceLexer;
    private final GestaltConfig gestaltConfig;
    private final ConfigNodeService configNodeService;
    private final ConfigNodeProcessorService configNodeProcessorService;
    private final CoreReloadListenersContainer coreReloadListenersContainer;
    private final SecretConcealer secretConcealer;
    private final List<ValidationError> loadErrors = new ArrayList<ValidationError>();
    private final Tags defaultTags;
    private final ObservationService observationService;
    private final ResultsProcessorService resultsProcessorService;
    private final DecoderContext decoderContext;
    private final TagMergingStrategy tagMergingStrategy;

    public GestaltCore(ConfigLoaderService configLoaderService, List<ConfigSourcePackage> configSourcePackages, DecoderService decoderService, SentenceLexer sentenceLexer, GestaltConfig gestaltConfig, ConfigNodeService configNodeService, ConfigNodeProcessorService configNodeProcessorService, CoreReloadListenersContainer reloadStrategy, SecretConcealer secretConcealer, ObservationService observationService, ResultsProcessorService resultsProcessorService, Tags defaultTags, TagMergingStrategy tagMergingStrategy) {
        this.configLoaderService = configLoaderService;
        this.sourcePackages = configSourcePackages;
        this.decoderService = decoderService;
        this.sentenceLexer = sentenceLexer;
        this.gestaltConfig = gestaltConfig;
        this.configNodeService = configNodeService;
        this.configNodeProcessorService = configNodeProcessorService;
        this.coreReloadListenersContainer = reloadStrategy;
        this.secretConcealer = secretConcealer;
        this.observationService = observationService;
        this.resultsProcessorService = resultsProcessorService;
        this.defaultTags = defaultTags;
        this.decoderContext = new DecoderContext(decoderService, this, secretConcealer, sentenceLexer);
        this.tagMergingStrategy = tagMergingStrategy;
    }

    List<ValidationError> getLoadErrors() {
        return this.loadErrors;
    }

    @Override
    public DecoderService getDecoderService() {
        return this.decoderService;
    }

    @Override
    public DecoderContext getDecoderContext() {
        return this.decoderContext;
    }

    public GestaltConfig getGestaltConfig() {
        return this.gestaltConfig;
    }

    @Override
    public void registerListener(CoreReloadListener listener) {
        this.coreReloadListenersContainer.registerListener(listener);
    }

    @Override
    public void removeListener(CoreReloadListener listener) {
        this.coreReloadListenersContainer.removeListener(listener);
    }

    @Override
    public void loadConfigs() throws GestaltException {
        if (this.sourcePackages == null || this.sourcePackages.isEmpty()) {
            throw new GestaltException("No sources provided, unable to load any configs");
        }
        for (ConfigSourcePackage sourcePackage : this.sourcePackages) {
            ConfigSource source = sourcePackage.getConfigSource();
            ConfigLoader configLoader = this.configLoaderService.getLoader(source.format());
            GResultOf<List<ConfigNodeContainer>> newNode = configLoader.loadSource(sourcePackage);
            this.validateLoadResultsForErrors(newNode, source);
            if (newNode.hasResults()) {
                for (ConfigNodeContainer node : newNode.results()) {
                    GResultOf<ConfigNode> mergedNode = this.configNodeService.addNode(node);
                    this.validateLoadResultsForErrors(mergedNode, source);
                    this.loadErrors.addAll(mergedNode.getErrors());
                }
                continue;
            }
            logger.log(System.Logger.Level.WARNING, "Failed to load node: {0} did not have any results", source.name());
        }
        this.postProcessConfigs();
    }

    @Override
    public void reload(ConfigSourcePackage reloadSourcePackage) throws GestaltException {
        ObservationMarker reloadMarker = null;
        try {
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                reloadMarker = this.observationService.startObservation("reload", Tags.of(Tags.of("source", reloadSourcePackage.getConfigSource().name()), reloadSourcePackage.getTags()));
            }
            if (reloadSourcePackage == null) {
                throw new GestaltException("No sources provided, unable to reload any configs");
            }
            if (this.sourcePackages == null || this.sourcePackages.isEmpty()) {
                throw new GestaltException("No sources provided, unable to reload any configs");
            }
            Optional<ConfigSourcePackage> sourcePackageOpt = this.sourcePackages.stream().filter(it -> it.equals(reloadSourcePackage)).findFirst();
            if (sourcePackageOpt.isEmpty()) {
                throw new GestaltException("Can not reload a source that was not registered.");
            }
            ConfigSource reloadSource = sourcePackageOpt.get().getConfigSource();
            ConfigLoader configLoader = this.configLoaderService.getLoader(reloadSourcePackage.getConfigSource().format());
            GResultOf<List<ConfigNodeContainer>> reloadNodes = configLoader.loadSource(sourcePackageOpt.get());
            this.validateLoadResultsForErrors(reloadNodes, reloadSource);
            reloadNodes.throwIfNoResults(() -> new GestaltException("no results found reloading source " + reloadSource.name()));
            for (ConfigNodeContainer reloadNode : reloadNodes.results()) {
                GResultOf<ConfigNode> mergedNode = this.configNodeService.reloadNode(reloadNode);
                this.validateLoadResultsForErrors(mergedNode, reloadSource);
                mergedNode.throwIfNoResults(() -> new GestaltException("no results found merging source " + reloadSource.name()));
                this.postProcessConfigs();
            }
            this.coreReloadListenersContainer.reload();
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                this.observationService.finalizeObservation(reloadMarker, Tags.of());
            }
        }
        catch (Exception ex) {
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                this.observationService.finalizeObservation(reloadMarker, Tags.of("exception", ex.getClass().getCanonicalName()));
            }
            throw ex;
        }
    }

    void postProcessConfigs() throws GestaltException {
        GResultOf<Boolean> results = this.configNodeService.processConfigNodes();
        if (ErrorsUtil.checkErrorsShouldFail(results, this.gestaltConfig)) {
            throw new GestaltException("Failed post processing config nodes with errors ", results.getErrors());
        }
        if (results.hasErrors() && logger.isLoggable(System.Logger.Level.DEBUG)) {
            String errorMsg = ErrorsUtil.buildErrorMessage("Failed post processing config nodes with errors ", results.getErrors());
            logger.log(System.Logger.Level.DEBUG, errorMsg);
        }
        this.loadErrors.addAll(results.getErrors());
        results.throwIfNoResults(() -> new GestaltException("no results found post processing the config nodes"));
    }

    private void validateLoadResultsForErrors(GResultOf<?> results, ConfigSource source) throws GestaltConfigurationException {
        if (this.gestaltConfig.isTreatWarningsAsErrors() && results.hasErrors() || results.hasErrors(ValidationLevel.ERROR) && source.failOnErrors()) {
            throw new GestaltConfigurationException("Failed to load configs from source: " + source.name(), results.getErrors());
        }
        if (results.hasErrors(ValidationLevel.WARN) && logger.isLoggable(System.Logger.Level.WARNING)) {
            String errorMsg = ErrorsUtil.buildErrorMessage(results.getErrors());
            logger.log(System.Logger.Level.WARNING, errorMsg);
        }
        results.throwIfNoResults(() -> new GestaltConfigurationException("No results found for node"));
    }

    private <T> String buildPathWithConfigPrefix(TypeCapture<T> klass, String path) {
        ConfigPrefix[] prefix;
        StringBuilder combinedPath = new StringBuilder(path);
        for (ConfigPrefix configPrefix : prefix = (ConfigPrefix[])klass.getAnnotationsByType(ConfigPrefix.class)) {
            if (combinedPath.length() > 0) {
                combinedPath.append(this.sentenceLexer.getNormalizedDeliminator());
            }
            combinedPath.append(configPrefix.prefix());
        }
        return combinedPath.toString();
    }

    @Override
    public <T> T getConfig(String path, Class<T> klass) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        return this.getConfigCommon(path, TypeCapture.of(klass), null).results();
    }

    @Override
    public <T> T getConfig(String path, Class<T> klass, Tags tags) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigCommon(path, TypeCapture.of(klass), tags).results();
    }

    @Override
    public <T> T getConfig(String path, TypeCapture<T> klass) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        return this.getConfigCommon(path, klass, null).results();
    }

    @Override
    public <T> T getConfig(String path, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigCommon(path, klass, tags).results();
    }

    @Override
    public <T> GResultOf<T> getConfigResult(String path, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigCommon(path, klass, tags);
    }

    private <T> GResultOf<T> getConfigCommon(String path, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Pair isOptionalAndDefault = ClassUtils.isOptionalAndDefault(klass.getRawType());
        Tags resolvedTags = this.tagMergingStrategy.mergeTags(tags, this.defaultTags);
        return this.getConfigurationInternal(path, isOptionalAndDefault.getFirst() == false, isOptionalAndDefault.getSecond(), klass, resolvedTags);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, Class<T> klass) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        return this.getConfigCommon(path, defaultVal, TypeCapture.of(klass), null).results();
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, Class<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigCommon(path, defaultVal, TypeCapture.of(klass), null).results();
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, TypeCapture<T> klass) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        return this.getConfigCommon(path, defaultVal, klass, null).results();
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigCommon(path, defaultVal, klass, tags).results();
    }

    @Override
    public <T> GResultOf<T> getConfigResult(String path, T defaultVal, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigCommon(path, defaultVal, klass, tags);
    }

    private <T> GResultOf<T> getConfigCommon(String path, T defaultVal, TypeCapture<T> klass, Tags tags) {
        try {
            Tags resolvedTags = this.tagMergingStrategy.mergeTags(tags, this.defaultTags);
            return this.getConfigurationInternal(path, false, defaultVal, klass, resolvedTags);
        }
        catch (GestaltException e) {
            logger.log(System.Logger.Level.WARNING, e.getMessage());
            return GResultOf.result(defaultVal);
        }
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, Class<T> klass) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        return this.getConfigOptionalCommon(path, TypeCapture.of(klass), this.defaultTags).map(GResultOf::results);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, Class<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigOptionalCommon(path, TypeCapture.of(klass), tags).map(GResultOf::results);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, TypeCapture<T> klass) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        return this.getConfigOptionalCommon(path, klass, this.defaultTags).map(GResultOf::results);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigOptionalCommon(path, klass, tags).map(GResultOf::results);
    }

    @Override
    public <T> Optional<GResultOf<T>> getConfigOptionalResult(String path, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        return this.getConfigOptionalCommon(path, klass, tags);
    }

    private <T> Optional<GResultOf<T>> getConfigOptionalCommon(String path, TypeCapture<T> klass, Tags tags) {
        try {
            Tags resolvedTags = this.tagMergingStrategy.mergeTags(tags, this.defaultTags);
            GResultOf<Object> results = this.getConfigurationInternal(path, false, null, klass, resolvedTags);
            return Optional.ofNullable(results);
        }
        catch (GestaltException e) {
            logger.log(System.Logger.Level.WARNING, e.getMessage());
            return Optional.empty();
        }
    }

    private <T> GResultOf<T> getConfigurationInternal(String path, boolean failOnErrors, T defaultVal, TypeCapture<T> klass, Tags tags) throws GestaltException {
        ObservationMarker getConfigMarker = null;
        boolean defaultReturned = false;
        Exception exceptionThrown = null;
        try {
            String combinedPath;
            GResultOf<List<Token>> tokens;
            if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
                getConfigMarker = this.observationService.startGetConfig(path, klass, tags, failOnErrors);
            }
            if ((tokens = this.sentenceLexer.scan(combinedPath = this.buildPathWithConfigPrefix(klass, path))).hasErrors()) {
                throw new GestaltException("Unable to parse path: " + combinedPath, tokens.getErrors());
            }
            GResultOf<T> results = this.getAndDecodeConfig(combinedPath, tokens.results(), klass, tags);
            this.getConfigObservations(results, combinedPath, klass, tags, failOnErrors);
            GResultOf<T> processedResults = this.resultsProcessorService.processResults(results, path, !failOnErrors, defaultVal, klass, tags);
            defaultReturned = processedResults.isDefault();
            GResultOf<T> gResultOf = processedResults;
            this.finalizeObservations(getConfigMarker, defaultReturned, exceptionThrown);
            return gResultOf;
        }
        catch (Exception ex) {
            try {
                exceptionThrown = ex;
                throw ex;
            }
            catch (Throwable throwable) {
                this.finalizeObservations(getConfigMarker, defaultReturned, exceptionThrown);
                throw throwable;
            }
        }
    }

    private void finalizeObservations(ObservationMarker getConfigMarker, boolean defaultReturned, Exception exceptionThrown) {
        if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null && getConfigMarker != null) {
            HashSet<Tag> tagSet = new HashSet<Tag>();
            if (defaultReturned) {
                tagSet.add(Tag.of("default", "true"));
            }
            if (exceptionThrown != null) {
                tagSet.add(Tag.of("exception", exceptionThrown.getClass().getCanonicalName()));
            }
            this.observationService.finalizeObservation(getConfigMarker, Tags.of(tagSet));
        }
    }

    private <T> GResultOf<T> getAndDecodeConfig(String path, List<Token> tokens, TypeCapture<T> klass, Tags tags) {
        GResultOf<ConfigNode> node = this.configNodeService.navigateToNode(path, tokens, tags);
        if (!node.hasErrors() || node.hasErrors(ValidationLevel.MISSING_VALUE)) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            GResultOf<ConfigNode> processedResult = this.configNodeProcessorService.runTimeProcessConfigNodes(path, node.results());
            errors.addAll(processedResult.getErrors());
            ConfigNode processedNode = processedResult.results();
            GResultOf<T> decodedResults = this.decoderService.decodeNode(path, tags, processedNode, klass, this.decoderContext);
            Map<Object, Object> metadata = node.results() != null ? (node.results() instanceof LeafNode ? node.results().getMetadata() : node.results().getRolledUpMetadata()) : Map.of();
            if (!decodedResults.hasResults() && node.hasErrors(ValidationLevel.MISSING_VALUE)) {
                errors.addAll(node.getErrors());
            } else {
                errors.addAll(node.getErrorsNotLevel(ValidationLevel.MISSING_VALUE));
                errors.addAll(decodedResults.getErrors());
            }
            return GResultOf.resultOf(decodedResults.results(), errors, metadata);
        }
        return GResultOf.errors(node.getErrors());
    }

    private <T> void getConfigObservations(GResultOf<T> results, String path, TypeCapture<T> klass, Tags tags, boolean isOptional) throws GestaltException {
        if (this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
            int warnings;
            int errors;
            int missingOptional;
            this.observationService.recordObservation(results, path, klass, tags, isOptional);
            int missing = results.getErrors(ValidationLevel.MISSING_VALUE).size();
            if (missing != 0) {
                this.observationService.recordObservation("get.config.missing", missing, Tags.of("optional", "false"));
            }
            if ((missingOptional = results.getErrors(ValidationLevel.MISSING_OPTIONAL_VALUE).size()) != 0) {
                this.observationService.recordObservation("get.config.missing", missingOptional, Tags.of("optional", "true"));
            }
            if ((errors = results.getErrors(ValidationLevel.ERROR).size()) != 0) {
                this.observationService.recordObservation("get.config.error", errors, Tags.of());
            }
            if ((warnings = results.getErrors(ValidationLevel.WARN).size()) != 0) {
                this.observationService.recordObservation("get.config.warning", warnings, Tags.of());
            }
        }
    }

    @Override
    public String debugPrint(Tags tags) {
        return this.configNodeService.debugPrintRoot(tags, this.secretConcealer);
    }

    @Override
    public String debugPrint() {
        return this.configNodeService.debugPrintRoot(this.secretConcealer);
    }
}

