/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.builder;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.github.gestalt.config.Gestalt;
import org.github.gestalt.config.GestaltCache;
import org.github.gestalt.config.GestaltCore;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderRegistry;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.ProxyDecoderMode;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.GestaltModuleConfig;
import org.github.gestalt.config.exceptions.GestaltConfigurationException;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.loader.ConfigLoaderRegistry;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.node.ConfigNodeManager;
import org.github.gestalt.config.node.ConfigNodeService;
import org.github.gestalt.config.node.ConfigNodeTagResolutionStrategy;
import org.github.gestalt.config.node.EqualTagsWithDefaultTagResolutionStrategy;
import org.github.gestalt.config.node.TagMergingStrategy;
import org.github.gestalt.config.node.TagMergingStrategyFallback;
import org.github.gestalt.config.node.factory.ConfigNodeFactory;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryConfig;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryManager;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryService;
import org.github.gestalt.config.observations.ObservationManager;
import org.github.gestalt.config.observations.ObservationRecorder;
import org.github.gestalt.config.observations.ObservationService;
import org.github.gestalt.config.path.mapper.PathMapper;
import org.github.gestalt.config.processor.config.ConfigNodeProcessor;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorConfig;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorManager;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorService;
import org.github.gestalt.config.processor.config.RunTimeConfigNodeProcessor;
import org.github.gestalt.config.processor.result.DefaultResultProcessor;
import org.github.gestalt.config.processor.result.ErrorResultProcessor;
import org.github.gestalt.config.processor.result.ResultProcessor;
import org.github.gestalt.config.processor.result.ResultsProcessorManager;
import org.github.gestalt.config.processor.result.ResultsProcessorService;
import org.github.gestalt.config.processor.result.validation.ConfigValidator;
import org.github.gestalt.config.processor.result.validation.ValidationResultProcessor;
import org.github.gestalt.config.reload.ConfigReloadStrategy;
import org.github.gestalt.config.reload.CoreReloadListener;
import org.github.gestalt.config.reload.CoreReloadListenersContainer;
import org.github.gestalt.config.secret.rules.RegexSecretChecker;
import org.github.gestalt.config.secret.rules.SecretChecker;
import org.github.gestalt.config.secret.rules.SecretConcealer;
import org.github.gestalt.config.secret.rules.SecretConcealerManager;
import org.github.gestalt.config.secret.rules.SecretObfuscator;
import org.github.gestalt.config.security.encrypted.EncryptedSecretModule;
import org.github.gestalt.config.security.temporary.TemporarySecretModule;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.CollectionUtils;
import org.github.gestalt.config.utils.Pair;

public class GestaltBuilder {
    private static final System.Logger logger = System.getLogger(GestaltBuilder.class.getName());
    private final List<ConfigReloadStrategy> reloadStrategies = new ArrayList<ConfigReloadStrategy>();
    private final List<CoreReloadListener> coreCoreReloadListeners = new ArrayList<CoreReloadListener>();
    private final Map<Class, GestaltModuleConfig> modules = new HashMap<Class, GestaltModuleConfig>();
    private final List<ResultProcessor> coreResultProcessors = List.of(new ErrorResultProcessor(), new DefaultResultProcessor());
    private ConfigLoaderService configLoaderService = new ConfigLoaderRegistry();
    private DecoderService decoderService;
    private SentenceLexer sentenceLexer;
    private GestaltConfig gestaltConfig = new GestaltConfig();
    private ObservationService observationService;
    private ResultsProcessorService resultsProcessorService;
    private ConfigNodeProcessorService configNodeProcessorService;
    private ConfigNodeService configNodeService;
    private ConfigNodeFactoryService configNodeFactoryService;
    private List<ConfigSourcePackage> configSourcePackages = new ArrayList<ConfigSourcePackage>();
    private List<Decoder<?>> decoders = new ArrayList();
    private List<ConfigLoader> configLoaders = new ArrayList<ConfigLoader>();
    private List<ConfigNodeProcessor> configNodeProcessors = new ArrayList<ConfigNodeProcessor>();
    private List<RunTimeConfigNodeProcessor> runTimeConfigNodeProcessors = new ArrayList<RunTimeConfigNodeProcessor>();
    private List<PathMapper> pathMappers = new ArrayList<PathMapper>();
    private List<ObservationRecorder> observationRecorders = new ArrayList<ObservationRecorder>();
    private List<ConfigValidator> configValidators = new ArrayList<ConfigValidator>();
    private List<ResultProcessor> resultProcessors = new ArrayList<ResultProcessor>();
    private List<ConfigNodeFactory> configSourceFactories = new ArrayList<ConfigNodeFactory>();
    private ConfigNodeTagResolutionStrategy configNodeTagResolutionStrategy;
    private TagMergingStrategy tagMergingStrategy;
    private boolean useCacheDecorator = true;
    private Set<String> securityMaskingRules = new HashSet<String>(List.of("bearer", "cookie", "credential", "id", "key", "keystore", "passphrase", "password", "private", "salt", "secret", "secure", "ssl", "token", "truststore"));
    private String secretMask = "*****";
    private List<Pair<SecretChecker, Integer>> secretAccessCounts = new ArrayList<Pair<SecretChecker, Integer>>();
    private SecretChecker encryptedSecrets = new RegexSecretChecker(new HashSet<String>());
    private SecretConcealer secretConcealer;
    private SecretObfuscator secretObfuscator = it -> this.secretMask;
    private Boolean treatWarningsAsErrors = null;
    private Boolean treatMissingArrayIndexAsError = null;
    private Boolean treatMissingValuesAsErrors = null;
    private Boolean treatMissingDiscretionaryValuesAsErrors = null;
    private Boolean observationsEnabled = null;
    private boolean validationEnabled = false;
    private boolean addCoreResultProcessors = true;
    private System.Logger.Level logLevelForMissingValuesWhenDefaultOrOptional = null;
    private DateTimeFormatter dateDecoderFormat = null;
    private DateTimeFormatter localDateTimeFormat = null;
    private DateTimeFormatter localDateFormat = null;
    private String substitutionOpeningToken = null;
    private String substitutionClosingToken = null;
    private String runTimeSubstitutionOpeningToken = "#{";
    private String runTimeSubstitutionClosingToken = "}";
    private String annotationOpeningToken = null;
    private String annotationClosingToken = null;
    private String annotationRegex = null;
    private Boolean annotationTrimWhiteSpace = null;
    private Integer maxSubstitutionNestedDepth = null;
    private String substitutionRegex = null;
    private String nodeIncludeKeyword = null;
    private Integer nodeNestedIncludeLimit = null;
    private ProxyDecoderMode proxyDecoderMode = null;
    private Tags defaultTags = Tags.of();

    public GestaltBuilder addDefaultDecoders() {
        ArrayList decodersSet = new ArrayList();
        ServiceLoader<Decoder> loader = ServiceLoader.load(Decoder.class);
        loader.forEach(decodersSet::add);
        this.decoders.addAll(decodersSet);
        return this;
    }

    public GestaltBuilder addDefaultConfigLoaders() {
        ArrayList configLoaderSet = new ArrayList();
        ServiceLoader<ConfigLoader> loader = ServiceLoader.load(ConfigLoader.class);
        loader.forEach(configLoaderSet::add);
        this.configLoaders.addAll(configLoaderSet);
        return this;
    }

    public GestaltBuilder addDefaultPostProcessors() {
        ArrayList configNodeProcessorsSet = new ArrayList();
        ServiceLoader<ConfigNodeProcessor> loader = ServiceLoader.load(ConfigNodeProcessor.class);
        loader.forEach(configNodeProcessorsSet::add);
        this.configNodeProcessors.addAll(configNodeProcessorsSet);
        return this;
    }

    public GestaltBuilder addDefaultRunTimeConfigNodeProcessor() {
        ArrayList configNodeProcessorsSet = new ArrayList();
        ServiceLoader<RunTimeConfigNodeProcessor> loader = ServiceLoader.load(RunTimeConfigNodeProcessor.class);
        loader.forEach(configNodeProcessorsSet::add);
        this.runTimeConfigNodeProcessors.addAll(configNodeProcessorsSet);
        return this;
    }

    public GestaltBuilder addDefaultObservationsRecorder() {
        ArrayList observationRecordersSet = new ArrayList();
        ServiceLoader<ObservationRecorder> loader = ServiceLoader.load(ObservationRecorder.class);
        loader.forEach(observationRecordersSet::add);
        this.observationRecorders.addAll(observationRecordersSet);
        return this;
    }

    public GestaltBuilder addDefaultValidators() {
        ArrayList validatorsSet = new ArrayList();
        ServiceLoader<ConfigValidator> loader = ServiceLoader.load(ConfigValidator.class);
        loader.forEach(validatorsSet::add);
        this.configValidators.addAll(validatorsSet);
        return this;
    }

    public GestaltBuilder addDefaultResultProcessor() {
        ArrayList resultProcessorSet = new ArrayList();
        ServiceLoader<ResultProcessor> loader = ServiceLoader.load(ResultProcessor.class);
        loader.forEach(resultProcessorSet::add);
        this.resultProcessors.addAll(resultProcessorSet);
        return this;
    }

    public GestaltBuilder addDefaultPathMappers() {
        ArrayList pathMappersSet = new ArrayList();
        ServiceLoader<PathMapper> loader = ServiceLoader.load(PathMapper.class);
        loader.forEach(pathMappersSet::add);
        this.pathMappers.addAll(pathMappersSet);
        return this;
    }

    public GestaltBuilder addDefaultConfigSourceFactory() {
        ArrayList configSourceFactorySet = new ArrayList();
        ServiceLoader<ConfigNodeFactory> loader = ServiceLoader.load(ConfigNodeFactory.class);
        loader.forEach(configSourceFactorySet::add);
        this.configSourceFactories.addAll(configSourceFactorySet);
        return this;
    }

    @Deprecated(since="0.23.4")
    public GestaltBuilder addSource(ConfigSource source) {
        Objects.requireNonNull(source, "Source should not be null");
        this.configSourcePackages.add(new ConfigSourcePackage(source, List.of(), source.getTags()));
        return this;
    }

    public GestaltBuilder addSource(ConfigSourcePackage configSourcePackage) {
        Objects.requireNonNull(configSourcePackage, "ConfigSourcePackage should not be null");
        this.configSourcePackages.add(configSourcePackage);
        return this;
    }

    public GestaltBuilder setSources(List<ConfigSourcePackage> configSourcePackage) {
        Objects.requireNonNull(configSourcePackage, "ConfigSourcePackage should not be null");
        this.configSourcePackages = new ArrayList<ConfigSourcePackage>(configSourcePackage);
        return this;
    }

    public GestaltBuilder addSources(List<ConfigSourcePackage> configSourcePackage) {
        Objects.requireNonNull(configSourcePackage, "ConfigSourcePackage should not be null");
        this.configSourcePackages.addAll(configSourcePackage);
        return this;
    }

    @Deprecated(since="0.23.4", forRemoval=true)
    public GestaltBuilder addReloadStrategy(ConfigReloadStrategy configReloadStrategy) {
        Objects.requireNonNull(configReloadStrategy, "reloadStrategy should not be null");
        this.reloadStrategies.add(configReloadStrategy);
        return this;
    }

    @Deprecated(since="0.23.4", forRemoval=true)
    public GestaltBuilder addReloadStrategies(List<ConfigReloadStrategy> reloadStrategies) {
        Objects.requireNonNull(reloadStrategies, "reloadStrategies should not be null");
        this.reloadStrategies.addAll(reloadStrategies);
        return this;
    }

    public GestaltBuilder addCoreReloadListener(CoreReloadListener coreReloadListener) {
        Objects.requireNonNull(coreReloadListener, "coreReloadListener should not be null");
        this.coreCoreReloadListeners.add(coreReloadListener);
        return this;
    }

    public GestaltBuilder addCoreReloadListener(List<CoreReloadListener> coreCoreReloadListeners) {
        Objects.requireNonNull(this.reloadStrategies, "reloadStrategies should not be null");
        this.coreCoreReloadListeners.addAll(coreCoreReloadListeners);
        return this;
    }

    public GestaltBuilder setConfigLoaderService(ConfigLoaderService configLoaderService) {
        Objects.requireNonNull(configLoaderService, "ConfigLoaderRegistry should not be null");
        this.configLoaderService = configLoaderService;
        return this;
    }

    public GestaltBuilder setConfigLoaders(List<ConfigLoader> configLoaders) throws GestaltConfigurationException {
        if (configLoaders == null || configLoaders.isEmpty()) {
            throw new GestaltConfigurationException("No config loader provided while setting config loaders");
        }
        this.configLoaders = new ArrayList<ConfigLoader>(configLoaders);
        return this;
    }

    public GestaltBuilder addConfigLoaders(List<ConfigLoader> configLoaders) throws GestaltConfigurationException {
        if (configLoaders == null || configLoaders.isEmpty()) {
            throw new GestaltConfigurationException("No config loader provided while adding config loaders");
        }
        this.configLoaders.addAll(configLoaders);
        return this;
    }

    public GestaltBuilder addConfigLoader(ConfigLoader configLoader) {
        Objects.requireNonNull(configLoader, "ConfigLoader should not be null");
        this.configLoaders.add(configLoader);
        return this;
    }

    public GestaltBuilder setConfigNodeProcessors(List<ConfigNodeProcessor> configNodeProcessors) throws GestaltConfigurationException {
        if (configNodeProcessors == null || configNodeProcessors.isEmpty()) {
            throw new GestaltConfigurationException("No ConfigNodeProcessor provided while setting");
        }
        this.configNodeProcessors = new ArrayList<ConfigNodeProcessor>(configNodeProcessors);
        return this;
    }

    public GestaltBuilder addConfigNodeProcessors(List<ConfigNodeProcessor> configNodeProcessors) throws GestaltConfigurationException {
        if (configNodeProcessors == null || configNodeProcessors.isEmpty()) {
            throw new GestaltConfigurationException("No ConfigNodeProcessor provided while adding");
        }
        this.configNodeProcessors.addAll(configNodeProcessors);
        return this;
    }

    public GestaltBuilder addConfigNodeProcessor(ConfigNodeProcessor configNodeProcessor) {
        Objects.requireNonNull(configNodeProcessor, "ConfigNodeProcessor should not be null");
        this.configNodeProcessors.add(configNodeProcessor);
        return this;
    }

    public GestaltBuilder setRunTimeConfigNodeProcessors(List<RunTimeConfigNodeProcessor> runTimeConfigNodeProcessors) throws GestaltConfigurationException {
        if (runTimeConfigNodeProcessors == null || runTimeConfigNodeProcessors.isEmpty()) {
            throw new GestaltConfigurationException("No ConfigNodeProcessor provided while setting");
        }
        this.runTimeConfigNodeProcessors = new ArrayList<RunTimeConfigNodeProcessor>(runTimeConfigNodeProcessors);
        return this;
    }

    public GestaltBuilder addRunTimeConfigNodeProcessors(List<RunTimeConfigNodeProcessor> runTimeConfigNodeProcessors) throws GestaltConfigurationException {
        if (runTimeConfigNodeProcessors == null || runTimeConfigNodeProcessors.isEmpty()) {
            throw new GestaltConfigurationException("No ConfigNodeProcessor provided while adding");
        }
        this.runTimeConfigNodeProcessors.addAll(runTimeConfigNodeProcessors);
        return this;
    }

    public GestaltBuilder addRunTimeConfigNodeProcessor(RunTimeConfigNodeProcessor runTimeConfigNodeProcessor) {
        Objects.requireNonNull(runTimeConfigNodeProcessor, "ConfigNodeProcessor should not be null");
        this.runTimeConfigNodeProcessors.add(runTimeConfigNodeProcessor);
        return this;
    }

    public GestaltBuilder setPathMappers(List<PathMapper> pathMappers) throws GestaltConfigurationException {
        if (pathMappers == null || pathMappers.isEmpty()) {
            throw new GestaltConfigurationException("No PathMappers provided while setting");
        }
        this.pathMappers = pathMappers;
        return this;
    }

    @Deprecated(since="0.25.3", forRemoval=true)
    public GestaltBuilder addPathMapper(List<PathMapper> pathMappers) throws GestaltConfigurationException {
        this.addPathMappers(pathMappers);
        return this;
    }

    public GestaltBuilder addPathMapper(PathMapper pathMapper) {
        Objects.requireNonNull(pathMapper, "PathMapper should not be null");
        this.pathMappers.add(pathMapper);
        return this;
    }

    public GestaltBuilder addPathMappers(List<PathMapper> pathMappers) throws GestaltConfigurationException {
        if (pathMappers == null || pathMappers.isEmpty()) {
            throw new GestaltConfigurationException("No PathMapper provided while adding");
        }
        this.pathMappers.addAll(pathMappers);
        return this;
    }

    public GestaltBuilder setObservationsRecorders(List<ObservationRecorder> observationRecorders) {
        Objects.requireNonNull(observationRecorders, "No ObservationRecorder provided while setting");
        this.observationRecorders = new ArrayList<ObservationRecorder>(observationRecorders);
        return this;
    }

    public GestaltBuilder addObservationsRecorders(List<ObservationRecorder> observationRecordersSet) {
        Objects.requireNonNull(observationRecordersSet, "ObservationRecorder should not be null");
        this.observationRecorders.addAll(observationRecordersSet);
        return this;
    }

    public GestaltBuilder addObservationsRecorder(ObservationRecorder observationRecorder) {
        Objects.requireNonNull(observationRecorder, "ObservationRecorder should not be null");
        this.observationRecorders.add(observationRecorder);
        return this;
    }

    public GestaltBuilder setValidators(List<ConfigValidator> configValidators) {
        Objects.requireNonNull(configValidators, "No Validators provided while setting");
        this.configValidators = new ArrayList<ConfigValidator>(configValidators);
        return this;
    }

    public GestaltBuilder addValidators(List<ConfigValidator> validatorsSet) {
        Objects.requireNonNull(validatorsSet, "Validator should not be null");
        this.configValidators.addAll(validatorsSet);
        return this;
    }

    public GestaltBuilder addValidator(ConfigValidator configValidator) {
        Objects.requireNonNull(configValidator, "Validator should not be null");
        this.configValidators.add(configValidator);
        return this;
    }

    public GestaltBuilder setResultProcessor(List<ResultProcessor> resultProcessors) {
        Objects.requireNonNull(resultProcessors, "ResultProcessor should not be null");
        this.resultProcessors = new ArrayList<ResultProcessor>(resultProcessors);
        return this;
    }

    public GestaltBuilder addResultProcessors(List<ResultProcessor> resultProcessorSet) {
        Objects.requireNonNull(resultProcessorSet, "ResultProcessor should not be null");
        this.resultProcessors.addAll(resultProcessorSet);
        return this;
    }

    public GestaltBuilder addResultProcessor(ResultProcessor resultProcessor) {
        Objects.requireNonNull(resultProcessor, "ResultProcessor should not be null");
        this.resultProcessors.add(resultProcessor);
        return this;
    }

    public GestaltBuilder setConfigSourceFactoryService(ConfigNodeFactoryService configNodeFactoryService) {
        Objects.requireNonNull(configNodeFactoryService, "ConfigSourceFactoryService should not be null");
        this.configNodeFactoryService = configNodeFactoryService;
        return this;
    }

    public GestaltBuilder setConfigSourceFactories(List<ConfigNodeFactory> configSourceFactories) {
        Objects.requireNonNull(configSourceFactories, "ConfigSourceFactory should not be null");
        this.configSourceFactories = new ArrayList<ConfigNodeFactory>(configSourceFactories);
        return this;
    }

    public GestaltBuilder addConfigSourceFactories(List<ConfigNodeFactory> configSourceFactorySet) {
        Objects.requireNonNull(configSourceFactorySet, "ConfigSourceFactory should not be null");
        this.configSourceFactories.addAll(configSourceFactorySet);
        return this;
    }

    public GestaltBuilder addConfigSourceFactory(ConfigNodeFactory configSourceFactory) {
        Objects.requireNonNull(configSourceFactory, "ConfigSourceFactory should not be null");
        this.configSourceFactories.add(configSourceFactory);
        return this;
    }

    public GestaltBuilder setSecurityMask(String mask) {
        this.secretMask = mask;
        return this;
    }

    public GestaltBuilder addSecurityMaskingRule(String regex) {
        this.securityMaskingRules.add(regex);
        return this;
    }

    public GestaltBuilder setSecurityMaskingRule(Set<String> regexs) {
        this.securityMaskingRules = regexs;
        return this;
    }

    public GestaltBuilder addTemporaryNodeAccessCount(String regex) {
        this.secretAccessCounts.add(new Pair<RegexSecretChecker, Integer>(new RegexSecretChecker(Set.of(regex)), 1));
        return this;
    }

    public GestaltBuilder addTemporaryNodeAccessCount(String regex, int accessCount) {
        this.secretAccessCounts.add(new Pair<RegexSecretChecker, Integer>(new RegexSecretChecker(Set.of(regex)), accessCount));
        return this;
    }

    public GestaltBuilder addTemporaryNodeAccessCount(Set<String> regexs, int accessCount) {
        this.secretAccessCounts.add(new Pair<RegexSecretChecker, Integer>(new RegexSecretChecker(regexs), accessCount));
        return this;
    }

    public GestaltBuilder setTemporaryNodeAccessCount(List<Pair<SecretChecker, Integer>> secretAccessCounts) {
        Objects.requireNonNull(secretAccessCounts, "secretAccessCounts should not be null");
        this.secretAccessCounts = secretAccessCounts;
        return this;
    }

    public GestaltBuilder setEncryptedSecrets(SecretChecker encryptedSecrets) {
        Objects.requireNonNull(encryptedSecrets, "encryptedSecrets should not be null");
        this.encryptedSecrets = encryptedSecrets;
        return this;
    }

    public GestaltBuilder addEncryptedSecret(String regex) {
        Objects.requireNonNull(regex, "regex should not be null");
        this.encryptedSecrets.addSecret(regex);
        return this;
    }

    public GestaltBuilder setSentenceLexer(SentenceLexer sentenceLexer) {
        Objects.requireNonNull(sentenceLexer, "SentenceLexer should not be null");
        this.sentenceLexer = sentenceLexer;
        return this;
    }

    public GestaltBuilder setGestaltConfig(GestaltConfig gestaltConfig) {
        Objects.requireNonNull(gestaltConfig, "GestaltConfig should not be null");
        this.gestaltConfig = gestaltConfig;
        return this;
    }

    public GestaltBuilder setConfigNodeService(ConfigNodeService configNodeService) {
        Objects.requireNonNull(configNodeService, "ConfigNodeService should not be null");
        this.configNodeService = configNodeService;
        return this;
    }

    public GestaltBuilder setObservationsService(ObservationService observationService) {
        Objects.requireNonNull(observationService, "observationService should not be null");
        this.observationService = observationService;
        observationService.addObservationRecorders(this.observationRecorders);
        return this;
    }

    public GestaltBuilder setSecretConcealer(SecretConcealer secretConcealer) {
        this.secretConcealer = secretConcealer;
        return this;
    }

    public GestaltBuilder setSecretObfuscation(SecretObfuscator secretObfuscator) {
        this.secretObfuscator = secretObfuscator;
        return this;
    }

    public GestaltBuilder setResultsProcessorService(ResultsProcessorService resultsProcessorService) {
        Objects.requireNonNull(resultsProcessorService, "ResultsProcessorService should not be null");
        this.resultsProcessorService = resultsProcessorService;
        resultsProcessorService.addResultProcessors(this.resultProcessors);
        return this;
    }

    public GestaltBuilder setConfigNodeProcessorService(ConfigNodeProcessorService configNodeProcessorService) {
        Objects.requireNonNull(configNodeProcessorService, "ConfigNodeProcessorService should not be null");
        this.configNodeProcessorService = configNodeProcessorService;
        configNodeProcessorService.addConfigNodeProcessors(this.configNodeProcessors);
        return this;
    }

    public GestaltBuilder setDecoderService(DecoderService decoderService) {
        Objects.requireNonNull(decoderService, "DecoderService should not be null");
        this.decoderService = decoderService;
        decoderService.addDecoders(this.decoders);
        return this;
    }

    public GestaltBuilder setDecoders(List<Decoder<?>> decoders) throws GestaltConfigurationException {
        if (decoders == null || decoders.isEmpty()) {
            throw new GestaltConfigurationException("No decoders provided while setting decoders");
        }
        this.decoders = decoders;
        return this;
    }

    public GestaltBuilder addDecoders(List<Decoder<?>> decoders) throws GestaltConfigurationException {
        if (decoders == null || decoders.isEmpty()) {
            throw new GestaltConfigurationException("No decoders provided while adding decoders");
        }
        this.decoders.addAll(decoders);
        return this;
    }

    public GestaltBuilder addDecoder(Decoder decoder) {
        Objects.requireNonNull(decoder, "Decoder should not be null");
        this.decoders.add(decoder);
        return this;
    }

    public GestaltBuilder addModuleConfig(GestaltModuleConfig extension) {
        this.modules.put(extension.getClass(), extension);
        return this;
    }

    public GestaltBuilder setTreatWarningsAsErrors(boolean warningsAsErrors) {
        this.treatWarningsAsErrors = warningsAsErrors;
        return this;
    }

    public Boolean isTreatWarningsAsErrors() {
        return this.treatWarningsAsErrors;
    }

    public GestaltBuilder setTreatMissingArrayIndexAsError(Boolean treatMissingArrayIndexAsError) {
        this.treatMissingArrayIndexAsError = treatMissingArrayIndexAsError;
        return this;
    }

    public Boolean getTreatMissingValuesAsErrors() {
        return this.treatMissingValuesAsErrors;
    }

    public GestaltBuilder setTreatMissingValuesAsErrors(Boolean treatMissingValuesAsErrors) {
        this.treatMissingValuesAsErrors = treatMissingValuesAsErrors;
        return this;
    }

    public Boolean getTreatMissingDiscretionaryValuesAsErrors() {
        return this.treatMissingDiscretionaryValuesAsErrors;
    }

    public GestaltBuilder setTreatMissingDiscretionaryValuesAsErrors(boolean treatMissingDiscretionaryValuesAsErrors) {
        this.treatMissingDiscretionaryValuesAsErrors = treatMissingDiscretionaryValuesAsErrors;
        return this;
    }

    @Deprecated(since="0.25.0", forRemoval=true)
    public GestaltBuilder setTreatNullValuesInClassAsErrors(Boolean treatNullValuesInClassAsErrors) {
        return this;
    }

    public GestaltBuilder useCacheDecorator(boolean useCacheDecorator) {
        this.useCacheDecorator = useCacheDecorator;
        return this;
    }

    public GestaltBuilder setObservationsEnabled(Boolean observationsEnabled) {
        this.observationsEnabled = observationsEnabled;
        return this;
    }

    public GestaltBuilder setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        return this;
    }

    public GestaltBuilder setAddCoreResultProcessors(boolean addCoreResultProcessors) {
        this.addCoreResultProcessors = addCoreResultProcessors;
        return this;
    }

    public GestaltBuilder setConfigNodeTagResolutionStrategy(ConfigNodeTagResolutionStrategy configNodeTagResolutionStrategy) {
        this.configNodeTagResolutionStrategy = configNodeTagResolutionStrategy;
        return this;
    }

    public GestaltBuilder setTagMergingStrategy(TagMergingStrategy tagMergingStrategy) {
        this.tagMergingStrategy = tagMergingStrategy;
        return this;
    }

    public GestaltBuilder setDateDecoderFormat(DateTimeFormatter dateDecoderFormat) {
        this.dateDecoderFormat = dateDecoderFormat;
        return this;
    }

    public System.Logger.Level getLogLevelForMissingValuesWhenDefaultOrOptional() {
        return this.logLevelForMissingValuesWhenDefaultOrOptional;
    }

    public GestaltBuilder setLogLevelForMissingValuesWhenDefaultOrOptional(System.Logger.Level logLevelForMissingValuesWhenDefaultOrOptional) {
        this.logLevelForMissingValuesWhenDefaultOrOptional = logLevelForMissingValuesWhenDefaultOrOptional;
        return this;
    }

    public GestaltBuilder setLocalDateTimeFormat(DateTimeFormatter localDateTimeFormat) {
        this.localDateTimeFormat = localDateTimeFormat;
        return this;
    }

    public GestaltBuilder setLocalDateFormat(DateTimeFormatter localDateFormat) {
        this.localDateFormat = localDateFormat;
        return this;
    }

    public GestaltBuilder setSubstitutionOpeningToken(String substitutionOpeningToken) {
        this.substitutionOpeningToken = substitutionOpeningToken;
        return this;
    }

    public GestaltBuilder setSubstitutionClosingToken(String substitutionClosingToken) {
        this.substitutionClosingToken = substitutionClosingToken;
        return this;
    }

    public GestaltBuilder setRunTimeSubstitutionClosingToken(String runtTimeSubstitutionClosingToken) {
        this.runTimeSubstitutionClosingToken = runtTimeSubstitutionClosingToken;
        return this;
    }

    public GestaltBuilder setRunTimeSubstitutionOpeningToken(String runtTimeSubstitutionOpeningToken) {
        this.runTimeSubstitutionOpeningToken = runtTimeSubstitutionOpeningToken;
        return this;
    }

    public GestaltBuilder setAnnotationOpeningToken(String annotationOpeningToken) {
        this.annotationOpeningToken = annotationOpeningToken;
        return this;
    }

    public GestaltBuilder setAnnotationClosingToken(String annotationClosingToken) {
        this.annotationClosingToken = annotationClosingToken;
        return this;
    }

    public GestaltBuilder setAnnotationRegex(String annotationRegex) {
        this.annotationRegex = annotationRegex;
        return this;
    }

    public GestaltBuilder setAnnotationTrimWhiteSpace(Boolean annotationTrimWhiteSpace) {
        this.annotationTrimWhiteSpace = annotationTrimWhiteSpace;
        return this;
    }

    public Integer getMaxSubstitutionNestedDepth() {
        return this.maxSubstitutionNestedDepth;
    }

    public GestaltBuilder setMaxSubstitutionNestedDepth(Integer maxSubstitutionNestedDepth) {
        this.maxSubstitutionNestedDepth = maxSubstitutionNestedDepth;
        return this;
    }

    public String getSubstitutionRegex() {
        return this.substitutionRegex;
    }

    public GestaltBuilder setSubstitutionRegex(String substitutionRegex) {
        this.substitutionRegex = substitutionRegex;
        return this;
    }

    public GestaltBuilder setNodeIncludeKeyword(String nodeIncludeKeyword) {
        this.nodeIncludeKeyword = nodeIncludeKeyword;
        return this;
    }

    public GestaltBuilder setNodeNestedIncludeLimit(Integer nodeNestedIncludeLimit) {
        this.nodeNestedIncludeLimit = nodeNestedIncludeLimit;
        return this;
    }

    public ProxyDecoderMode getProxyDecoderMode() {
        return this.proxyDecoderMode;
    }

    public GestaltBuilder setProxyDecoderMode(ProxyDecoderMode proxyDecoderMode) {
        this.proxyDecoderMode = proxyDecoderMode;
        return this;
    }

    public Tags getDefaultTags() {
        return this.defaultTags;
    }

    public GestaltBuilder setDefaultTags(Tags defaultTags) {
        this.defaultTags = defaultTags;
        return this;
    }

    protected List<Decoder<?>> dedupeDecoders() {
        Map<String, List> decoderMap = this.decoders.stream().collect(Collectors.groupingBy(Decoder::name)).entrySet().stream().filter(it -> ((List)it.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!decoderMap.isEmpty()) {
            String duplicates = String.join((CharSequence)", ", decoderMap.keySet());
            logger.log(System.Logger.Level.WARNING, "Found duplicate decoders {0}", duplicates);
        }
        return this.decoders.stream().filter(CollectionUtils.distinctBy(Decoder::name)).collect(Collectors.toList());
    }

    protected List<ConfigLoader> dedupeConfigLoaders() {
        Map<String, List> configMap = this.configLoaders.stream().collect(Collectors.groupingBy(ConfigLoader::name)).entrySet().stream().filter(it -> ((List)it.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!configMap.isEmpty()) {
            String duplicates = String.join((CharSequence)", ", configMap.keySet());
            logger.log(System.Logger.Level.WARNING, "Found duplicate config loaders {0}", duplicates);
        }
        return this.configLoaders.stream().filter(CollectionUtils.distinctBy(ConfigLoader::name)).collect(Collectors.toList());
    }

    public Gestalt build() throws GestaltConfigurationException {
        if (this.configSourcePackages.isEmpty()) {
            throw new GestaltConfigurationException("No sources provided");
        }
        if (this.secretConcealer == null) {
            this.secretConcealer = new SecretConcealerManager(this.securityMaskingRules, this.secretObfuscator);
        }
        this.gestaltConfig = this.rebuildConfig();
        this.gestaltConfig.registerModuleConfig(this.modules);
        if (this.sentenceLexer == null) {
            this.sentenceLexer = new PathLexer();
        }
        if (this.configNodeTagResolutionStrategy == null) {
            this.configNodeTagResolutionStrategy = new EqualTagsWithDefaultTagResolutionStrategy();
        }
        if (this.configNodeProcessorService == null) {
            this.configNodeProcessorService = new ConfigNodeProcessorManager(List.of(), List.of(), this.sentenceLexer);
        }
        if (this.configNodeService == null) {
            this.configNodeService = new ConfigNodeManager(this.configNodeTagResolutionStrategy, this.configNodeProcessorService, this.sentenceLexer);
        }
        if (this.tagMergingStrategy == null) {
            this.tagMergingStrategy = new TagMergingStrategyFallback();
        }
        this.configurePathMappers();
        this.configureDecoders();
        this.configureObservations();
        this.configureValidation();
        this.configureCoreResultProcessors();
        this.configureResultProcessors();
        this.configureConfigLoaders();
        this.configureConfigSourceFactory();
        this.configureTemporaryNodesModule();
        this.configureEncryptedSecretsNodesModule();
        this.configureConfigNodeProcessor();
        this.configureRunTimeConfigNodeProcessor();
        CoreReloadListenersContainer coreReloadListenersContainer = new CoreReloadListenersContainer();
        GestaltCore gestaltCore = new GestaltCore(this.configLoaderService, this.configSourcePackages, this.decoderService, this.sentenceLexer, this.gestaltConfig, this.configNodeService, this.configNodeProcessorService, coreReloadListenersContainer, this.secretConcealer, this.observationService, this.resultsProcessorService, this.defaultTags, this.tagMergingStrategy);
        this.reloadStrategies.forEach(it -> it.registerListener(gestaltCore));
        this.configSourcePackages.stream().flatMap(it -> it.getConfigReloadStrategies().stream()).forEach(it -> it.registerListener(gestaltCore));
        this.coreCoreReloadListeners.forEach(coreReloadListenersContainer::registerListener);
        if (this.useCacheDecorator) {
            List<SecretChecker> nonCacheableSecrets = this.secretAccessCounts.stream().map(Pair::getFirst).collect(Collectors.toList());
            nonCacheableSecrets.add(this.encryptedSecrets);
            GestaltCache gestaltCache = new GestaltCache(gestaltCore, this.defaultTags, this.observationService, this.gestaltConfig, this.tagMergingStrategy, nonCacheableSecrets);
            coreReloadListenersContainer.registerListener(gestaltCache);
            return gestaltCache;
        }
        return gestaltCore;
    }

    private void configureConfigNodeProcessor() {
        if (this.configNodeProcessors.isEmpty()) {
            logger.log(System.Logger.Level.TRACE, "No Config Node Processors provided, using defaults");
            this.addDefaultPostProcessors();
        }
        this.configNodeProcessors = this.configNodeProcessors.stream().filter(Objects::nonNull).collect(Collectors.toList());
        ConfigNodeProcessorConfig config = new ConfigNodeProcessorConfig(this.gestaltConfig, this.configNodeService, this.sentenceLexer, this.secretConcealer, this.configNodeFactoryService);
        this.configNodeProcessors.forEach(it -> it.applyConfig(config));
        this.configNodeProcessorService.addConfigNodeProcessors(this.configNodeProcessors);
    }

    private void configureRunTimeConfigNodeProcessor() {
        if (this.runTimeConfigNodeProcessors.isEmpty()) {
            logger.log(System.Logger.Level.TRACE, "No Runtime Config Node Processors provided, using defaults");
            this.addDefaultRunTimeConfigNodeProcessor();
        }
        this.runTimeConfigNodeProcessors = this.runTimeConfigNodeProcessors.stream().filter(Objects::nonNull).collect(Collectors.toList());
        ConfigNodeProcessorConfig config = new ConfigNodeProcessorConfig(this.gestaltConfig, this.configNodeService, this.sentenceLexer, this.secretConcealer, this.configNodeFactoryService);
        this.runTimeConfigNodeProcessors.forEach(it -> it.applyConfig(config));
        this.configNodeProcessorService.addRuntimeConfigNodeProcessor(this.runTimeConfigNodeProcessors);
    }

    private void configureConfigLoaders() {
        if (this.configLoaders.isEmpty()) {
            logger.log(System.Logger.Level.TRACE, "No decoders provided, using defaults");
            this.addDefaultConfigLoaders();
        }
        this.configLoaders.addAll(this.configLoaderService.getConfigLoaders());
        List<ConfigLoader> dedupedConfigs = this.dedupeConfigLoaders();
        this.configLoaders = this.configLoaders.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.configLoaders.forEach(it -> it.applyConfig(this.gestaltConfig));
        this.configLoaderService.setLoaders(dedupedConfigs);
    }

    private void configureValidation() {
        if (this.validationEnabled) {
            if (this.configValidators.isEmpty()) {
                logger.log(System.Logger.Level.TRACE, "No validators recorders provided, using defaults");
                this.addDefaultValidators();
            }
            this.configValidators = this.configValidators.stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.configValidators.forEach(it -> it.applyConfig(this.gestaltConfig));
            ValidationResultProcessor validationResultProcessor = new ValidationResultProcessor(this.configValidators, this.observationService);
            validationResultProcessor.applyConfig(this.gestaltConfig);
            if (this.resultsProcessorService == null) {
                this.resultsProcessorService = new ResultsProcessorManager(List.of(validationResultProcessor));
            } else {
                this.resultsProcessorService.addResultProcessors(List.of(validationResultProcessor));
            }
        }
    }

    private void configureCoreResultProcessors() {
        if (this.coreResultProcessors.isEmpty() || !this.addCoreResultProcessors) {
            logger.log(System.Logger.Level.WARNING, "No Core ResultProcessors added, Gestalt may not behave as expected");
            return;
        }
        this.coreResultProcessors.forEach(it -> it.applyConfig(this.gestaltConfig));
        if (this.resultsProcessorService == null) {
            this.resultsProcessorService = new ResultsProcessorManager(this.coreResultProcessors);
        } else {
            this.resultsProcessorService.addResultProcessors(this.coreResultProcessors);
        }
    }

    private void configureResultProcessors() {
        if (this.resultProcessors.isEmpty()) {
            logger.log(System.Logger.Level.TRACE, "No resultProcessors provided, using defaults");
            this.addDefaultResultProcessor();
        }
        this.resultProcessors = this.resultProcessors.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.resultProcessors.forEach(it -> it.applyConfig(this.gestaltConfig));
        if (this.resultsProcessorService == null) {
            this.resultsProcessorService = new ResultsProcessorManager(this.resultProcessors);
        } else {
            this.resultsProcessorService.addResultProcessors(this.resultProcessors);
        }
    }

    private void configureConfigSourceFactory() {
        if (this.configSourceFactories.isEmpty()) {
            logger.log(System.Logger.Level.TRACE, "No configSourceFactories provided, using defaults");
            this.addDefaultConfigSourceFactory();
        }
        ConfigNodeFactoryConfig configNodeFactoryConfig = new ConfigNodeFactoryConfig(this.configLoaderService, this.configNodeService, this.sentenceLexer, this.gestaltConfig);
        this.configSourceFactories = this.configSourceFactories.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.configSourceFactories.forEach(it -> it.applyConfig(configNodeFactoryConfig));
        if (this.configNodeFactoryService == null) {
            this.configNodeFactoryService = new ConfigNodeFactoryManager(this.configSourceFactories);
        } else {
            this.configNodeFactoryService.addConfigSourceFactories(this.configSourceFactories);
        }
    }

    private void configureObservations() {
        if (this.observationRecorders.isEmpty()) {
            logger.log(System.Logger.Level.TRACE, "No observation recorders provided, using defaults");
            this.addDefaultObservationsRecorder();
        }
        this.observationRecorders = this.observationRecorders.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.observationRecorders.forEach(it -> it.applyConfig(this.gestaltConfig));
        if (this.observationService == null) {
            this.observationService = new ObservationManager(this.observationRecorders);
        } else {
            this.observationService.addObservationRecorders(this.observationRecorders);
        }
    }

    private void configurePathMappers() {
        if (this.pathMappers.isEmpty()) {
            logger.log(System.Logger.Level.TRACE, "No path mapper provided, using defaults");
            this.addDefaultPathMappers();
        }
        this.pathMappers = this.pathMappers.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.pathMappers.forEach(it -> it.applyConfig(this.gestaltConfig));
    }

    private void configureDecoders() throws GestaltConfigurationException {
        if (this.decoders.isEmpty()) {
            logger.log(System.Logger.Level.TRACE, "No decoders provided, using defaults");
            this.addDefaultDecoders();
        }
        this.decoders = this.decoders.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.decoders.forEach(it -> it.applyConfig(this.gestaltConfig));
        if (this.decoderService == null) {
            this.decoderService = new DecoderRegistry(this.decoders, this.configNodeService, this.sentenceLexer, this.pathMappers);
        } else {
            this.decoders.addAll(this.decoderService.getDecoders());
            List<Decoder<?>> dedupedDecoders = this.dedupeDecoders();
            this.decoderService.setDecoders(dedupedDecoders);
        }
    }

    private void configureTemporaryNodesModule() {
        if (this.secretAccessCounts != null && !this.secretAccessCounts.isEmpty()) {
            if (this.gestaltConfig.getModuleConfig(TemporarySecretModule.class) == null) {
                this.gestaltConfig.registerModuleConfig(new TemporarySecretModule(this.secretAccessCounts));
            } else {
                TemporarySecretModule module = this.gestaltConfig.getModuleConfig(TemporarySecretModule.class);
                module.addSecretCounts(this.secretAccessCounts);
            }
        }
    }

    private void configureEncryptedSecretsNodesModule() {
        if (this.gestaltConfig.getModuleConfig(EncryptedSecretModule.class) == null) {
            this.gestaltConfig.registerModuleConfig(new EncryptedSecretModule(this.encryptedSecrets));
        }
    }

    private GestaltConfig rebuildConfig() {
        GestaltConfig newConfig = new GestaltConfig();
        newConfig.setTreatWarningsAsErrors(Objects.requireNonNullElseGet(this.treatWarningsAsErrors, () -> this.gestaltConfig.isTreatWarningsAsErrors()));
        newConfig.setTreatMissingArrayIndexAsError(Objects.requireNonNullElseGet(this.treatMissingArrayIndexAsError, () -> this.gestaltConfig.isTreatMissingArrayIndexAsError()));
        newConfig.setTreatMissingValuesAsErrors(Objects.requireNonNullElseGet(this.treatMissingValuesAsErrors, () -> this.gestaltConfig.isTreatMissingValuesAsErrors()));
        newConfig.setTreatMissingDiscretionaryValuesAsErrors(Objects.requireNonNullElseGet(this.treatMissingDiscretionaryValuesAsErrors, () -> this.gestaltConfig.isTreatMissingDiscretionaryValuesAsErrors()));
        newConfig.setLogLevelForMissingValuesWhenDefaultOrOptional(Objects.requireNonNullElseGet(this.logLevelForMissingValuesWhenDefaultOrOptional, () -> this.gestaltConfig.getLogLevelForMissingValuesWhenDefaultOrOptional()));
        newConfig.setDateDecoderFormat(Objects.requireNonNullElseGet(this.dateDecoderFormat, () -> this.gestaltConfig.getDateDecoderFormat()));
        newConfig.setLocalDateTimeFormat(Objects.requireNonNullElseGet(this.localDateTimeFormat, () -> this.gestaltConfig.getLocalDateTimeFormat()));
        newConfig.setLocalDateFormat(Objects.requireNonNullElseGet(this.localDateFormat, () -> this.gestaltConfig.getLocalDateFormat()));
        newConfig.setSubstitutionOpeningToken(Objects.requireNonNullElseGet(this.substitutionOpeningToken, () -> this.gestaltConfig.getSubstitutionOpeningToken()));
        newConfig.setSubstitutionClosingToken(Objects.requireNonNullElseGet(this.substitutionClosingToken, () -> this.gestaltConfig.getSubstitutionClosingToken()));
        newConfig.setRunTimeSubstitutionOpeningToken(Objects.requireNonNullElseGet(this.runTimeSubstitutionOpeningToken, () -> this.gestaltConfig.getRunTimeSubstitutionOpeningToken()));
        newConfig.setRunTimeSubstitutionClosingToken(Objects.requireNonNullElseGet(this.runTimeSubstitutionClosingToken, () -> this.gestaltConfig.getRunTimeSubstitutionClosingToken()));
        newConfig.setAnnotationOpeningToken(Objects.requireNonNullElseGet(this.annotationOpeningToken, () -> this.gestaltConfig.getAnnotationOpeningToken()));
        newConfig.setAnnotationClosingToken(Objects.requireNonNullElseGet(this.annotationClosingToken, () -> this.gestaltConfig.getAnnotationClosingToken()));
        newConfig.setAnnotationTrimWhiteSpace(Objects.requireNonNullElseGet(this.annotationTrimWhiteSpace, () -> this.gestaltConfig.getAnnotationTrimWhiteSpace()));
        newConfig.setAnnotationRegex(Objects.requireNonNullElseGet(this.annotationRegex, () -> this.gestaltConfig.getAnnotationRegex()));
        newConfig.setMaxSubstitutionNestedDepth(Objects.requireNonNullElseGet(this.maxSubstitutionNestedDepth, () -> this.gestaltConfig.getMaxSubstitutionNestedDepth()));
        newConfig.setSubstitutionRegex(Objects.requireNonNullElseGet(this.substitutionRegex, () -> this.gestaltConfig.getSubstitutionRegex()));
        newConfig.setProxyDecoderMode(Objects.requireNonNullElseGet(this.proxyDecoderMode, () -> this.gestaltConfig.getProxyDecoderMode()));
        newConfig.setObservationsEnabled(Objects.requireNonNullElseGet(this.observationsEnabled, () -> this.gestaltConfig.isObservationsEnabled()));
        newConfig.setSentenceLexer(Objects.requireNonNullElseGet(this.sentenceLexer, () -> this.gestaltConfig.getSentenceLexer()));
        newConfig.setNodeIncludeKeyword(Objects.requireNonNullElseGet(this.nodeIncludeKeyword, () -> this.gestaltConfig.getNodeIncludeKeyword()));
        newConfig.setNodeNestedIncludeLimit(Objects.requireNonNullElseGet(this.nodeNestedIncludeLimit, () -> this.gestaltConfig.getNodeNestedIncludeLimit()));
        return newConfig;
    }
}

