/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.reload.ConfigReloadStrategy;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.tag.Tag;
import org.github.gestalt.config.tag.Tags;

public abstract class SourceBuilder<SELF extends SourceBuilder<SELF, T>, T extends ConfigSource> {
    protected final List<ConfigReloadStrategy> configReloadStrategies = new ArrayList<ConfigReloadStrategy>();
    protected ConfigSource source;
    protected Tags tags = Tags.of();

    public Tags getTags() {
        return this.tags;
    }

    public SELF setTags(Tags tags) {
        Objects.requireNonNull(tags, "tags must not be null");
        this.tags = tags;
        return this.self();
    }

    public SELF addTag(Tag tag) {
        Objects.requireNonNull(tag, "tag must not be null");
        this.tags = this.tags.and(tag);
        return this.self();
    }

    public SELF addTags(Tags tagsParam) {
        Objects.requireNonNull(tagsParam, "tag must not be null");
        this.tags = this.tags.and(tagsParam);
        return this.self();
    }

    public List<ConfigReloadStrategy> getConfigReloadStrategies() {
        return this.configReloadStrategies;
    }

    public SELF addConfigReloadStrategy(ConfigReloadStrategy configReloadStrategy) {
        Objects.requireNonNull(configReloadStrategy, "Config reloads strategy builder must not be null");
        this.configReloadStrategies.add(configReloadStrategy);
        return this.self();
    }

    public abstract ConfigSourcePackage build() throws GestaltException;

    protected ConfigSourcePackage buildPackage(ConfigSource source) throws GestaltException {
        Tags combinedTags = this.tags.and(source.getTags());
        ConfigSourcePackage configSourcePackage = new ConfigSourcePackage(source, this.configReloadStrategies, Tags.of(combinedTags));
        for (ConfigReloadStrategy reloadStrategy : this.configReloadStrategies) {
            reloadStrategy.setSource(configSourcePackage);
        }
        return configSourcePackage;
    }

    protected final SELF self() {
        return (SELF)this;
    }
}

