/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;

public final class ArrayDecoder<T>
implements Decoder<T[]> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Array";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return type.isArray();
    }

    @Override
    public GResultOf<T[]> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        GResultOf<Object> results;
        if (node instanceof ArrayNode) {
            results = this.arrayDecode(path, tags, node, type, decoderContext);
        } else if (node instanceof LeafNode) {
            Optional<String> valueOptional = node.getValue();
            if (valueOptional.isPresent()) {
                String value = valueOptional.get();
                String[] array = value.split("(?<!\\\\),");
                List<ConfigNode> leafNodes = Arrays.stream(array).map(String::trim).map(it -> it.replace("\\,", ",")).map(LeafNode::new).collect(Collectors.toList());
                results = this.arrayDecode(path, tags, new ArrayNode(leafNodes), type, decoderContext);
            } else {
                results = GResultOf.errors(new ValidationError.DecodingLeafMissingValue(path, this.name()));
            }
        } else {
            results = GResultOf.errors(new ValidationError.DecodingExpectedArrayNodeType(path, node, this.name()));
        }
        return results;
    }

    private GResultOf<T[]> arrayDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> klass, DecoderContext decoderContext) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Object[] results = (Object[])Array.newInstance(klass.getComponentType(), node.size());
        for (int i = 0; i < node.size(); ++i) {
            Optional<ConfigNode> valueOptional = node.getIndex(i);
            if (valueOptional.isPresent()) {
                ConfigNode currentNode = valueOptional.get();
                String nextPath = PathUtil.pathForIndex(decoderContext.getDefaultLexer(), path, i);
                GResultOf<?> resultOf = decoderContext.getDecoderService().decodeNode(nextPath, tags, currentNode, TypeCapture.of(klass.getComponentType()), decoderContext);
                errors.addAll(resultOf.getErrors());
                if (!resultOf.hasResults()) continue;
                results[i] = resultOf.results();
                continue;
            }
            errors.add(new ValidationError.ArrayMissingIndex(i));
            results[i] = null;
        }
        return GResultOf.resultOf(results, errors);
    }
}

