/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class BooleanDecoder
extends LeafDecoder<Boolean> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Boolean";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return Boolean.class.isAssignableFrom(type.getRawType()) || Boolean.TYPE.isAssignableFrom(type.getRawType());
    }

    @Override
    protected GResultOf<Boolean> leafDecode(String path, ConfigNode node, DecoderContext decoderContext) {
        String value = node.getValue().orElse("");
        return GResultOf.result(Boolean.parseBoolean(value));
    }
}

