/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.nio.charset.Charset;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class ByteDecoder
extends LeafDecoder<Byte> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Byte";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return Byte.class.isAssignableFrom(type.getRawType()) || Byte.TYPE.isAssignableFrom(type.getRawType());
    }

    @Override
    protected GResultOf<Byte> leafDecode(String path, ConfigNode node, DecoderContext decoderContext) {
        String value = node.getValue().orElse("");
        GResultOf<Byte> results = value.length() == 1 ? GResultOf.result(value.getBytes(Charset.defaultCharset())[0]) : (value.length() > 1 ? GResultOf.resultOf(Byte.valueOf(value.getBytes(Charset.defaultCharset())[0]), new ValidationError.DecodingByteTooLong(path, node, decoderContext)) : GResultOf.errors(new ValidationError.DecodingEmptyByte(path, node, decoderContext)));
        return results;
    }
}

