/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.ArrayList;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class CharDecoder
extends LeafDecoder<Character> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Character";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return Character.class.isAssignableFrom(type.getRawType()) || Character.TYPE.isAssignableFrom(type.getRawType());
    }

    @Override
    protected GResultOf<Character> leafDecode(String path, ConfigNode node, DecoderContext decoderContext) {
        Character results = null;
        ArrayList<ValidationError> error = new ArrayList<ValidationError>();
        String value = node.getValue().orElse("");
        if (!value.isEmpty()) {
            results = Character.valueOf(value.charAt(0));
        }
        if (value.length() != 1) {
            error.add(new ValidationError.DecodingCharWrongSize(path, node, decoderContext));
        }
        return GResultOf.resultOf(results, error);
    }
}

