/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public abstract class CollectionDecoder<T extends Collection<?>>
implements Decoder<T> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public GResultOf<T> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        GResultOf<T> results;
        if (node instanceof ArrayNode) {
            results = this.arrayDecode(path, tags, node, type, decoderContext);
        } else if (node instanceof LeafNode) {
            Optional<String> valueOptional = node.getValue();
            if (valueOptional.isPresent()) {
                String value = valueOptional.get();
                String[] array = value.split("(?<!\\\\),");
                List<ConfigNode> leafNodes = Arrays.stream(array).map(String::trim).map(it -> it.replace("\\,", ",")).map(LeafNode::new).collect(Collectors.toList());
                results = this.arrayDecode(path, tags, new ArrayNode(leafNodes), type, decoderContext);
            } else {
                results = GResultOf.errors(new ValidationError.DecodingLeafMissingValue(path, this.name()));
            }
        } else {
            results = GResultOf.errors(new ValidationError.DecodingExpectedArrayNodeType(path, node, this.name()));
        }
        return results;
    }

    protected abstract GResultOf<T> arrayDecode(String var1, Tags var2, ConfigNode var3, TypeCapture<?> var4, DecoderContext var5);
}

