/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class DateDecoder
extends LeafDecoder<Date> {
    private DateTimeFormatter formatter;

    public DateDecoder() {
        this.formatter = DateTimeFormatter.ISO_DATE_TIME;
    }

    public DateDecoder(String formatter) {
        this.formatter = formatter != null && !formatter.isEmpty() ? DateTimeFormatter.ofPattern(formatter) : DateTimeFormatter.ISO_DATE_TIME;
    }

    @Override
    public void applyConfig(GestaltConfig config) {
        if (config.getDateDecoderFormat() != null && this.formatter.equals(DateTimeFormatter.ISO_DATE_TIME)) {
            this.formatter = config.getDateDecoderFormat();
        }
    }

    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Date";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return Date.class.isAssignableFrom(type.getRawType());
    }

    @Override
    protected GResultOf<Date> leafDecode(String path, ConfigNode node, DecoderContext decoderContext) {
        GResultOf<Date> results;
        String value = node.getValue().orElse("");
        try {
            LocalDateTime ldt = LocalDateTime.parse(value, this.formatter);
            Instant instant = ldt.atZone(ZoneId.systemDefault()).toInstant();
            results = GResultOf.result(Date.from(instant));
        }
        catch (DateTimeParseException e) {
            results = GResultOf.errors(new ValidationError.ErrorDecodingException(path, node, this.name(), e.getMessage(), decoderContext));
        }
        return results;
    }
}

