/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.Objects;
import org.github.gestalt.config.Gestalt;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.secret.rules.SecretConcealer;

public class DecoderContext {
    private final DecoderService decoderService;
    private final Gestalt gestalt;
    private final SentenceLexer defaultLexer;
    private final SecretConcealer secretConcealer;

    public DecoderContext(DecoderService decoderService, Gestalt gestalt, SecretConcealer secretConcealer, SentenceLexer defaultLexer) {
        this.decoderService = decoderService;
        this.gestalt = gestalt;
        this.secretConcealer = secretConcealer;
        this.defaultLexer = defaultLexer;
    }

    public DecoderService getDecoderService() {
        return this.decoderService;
    }

    public Gestalt getGestalt() {
        return this.gestalt;
    }

    public SecretConcealer getSecretConcealer() {
        return this.secretConcealer;
    }

    public SentenceLexer getDefaultLexer() {
        return this.defaultLexer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecoderContext)) {
            return false;
        }
        DecoderContext that = (DecoderContext)o;
        return Objects.equals(this.decoderService, that.decoderService) && Objects.equals(this.gestalt, that.gestalt) && Objects.equals(this.secretConcealer, that.secretConcealer) && Objects.equals(this.defaultLexer, that.defaultLexer);
    }

    public int hashCode() {
        return Objects.hash(this.decoderService, this.gestalt, this.secretConcealer, this.defaultLexer);
    }
}

