/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltConfigurationException;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.ConfigNodeService;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.path.mapper.PathMapper;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.token.ArrayToken;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.CollectionUtils;
import org.github.gestalt.config.utils.GResultOf;

public final class DecoderRegistry
implements DecoderService {
    private static final System.Logger logger = System.getLogger(DecoderRegistry.class.getName());
    private final ConfigNodeService configNodeService;
    private final SentenceLexer lexer;
    private List<Decoder<?>> decoders = new ArrayList();
    private List<PathMapper> pathMappers;

    public DecoderRegistry(List<Decoder<?>> decoders, ConfigNodeService configNodeService, SentenceLexer lexer, List<PathMapper> pathMappers) throws GestaltConfigurationException {
        if (configNodeService == null) {
            throw new GestaltConfigurationException("ConfigNodeService can not be null");
        }
        this.configNodeService = configNodeService;
        if (lexer == null) {
            throw new GestaltConfigurationException("SentenceLexer can not be null");
        }
        this.lexer = lexer;
        if (pathMappers == null || pathMappers.isEmpty()) {
            throw new GestaltConfigurationException("pathMappers can not be null or empty");
        }
        this.pathMappers = CollectionUtils.buildOrderedConfigPriorities(pathMappers, false);
        if (decoders == null || decoders.isEmpty()) {
            throw new GestaltConfigurationException("Decoder list was null or empty");
        }
        this.decoders.addAll(decoders);
    }

    @Override
    public void addDecoders(List<Decoder<?>> addDecoders) {
        this.decoders.addAll(addDecoders);
    }

    @Override
    public List<Decoder<?>> getDecoders() {
        return this.decoders;
    }

    @Override
    public void setDecoders(List<Decoder<?>> decoders) {
        this.decoders = decoders;
    }

    @Override
    public List<PathMapper> getPathMappers() {
        return this.pathMappers;
    }

    @Override
    public void setPathMappers(List<PathMapper> pathMappers) {
        this.pathMappers = pathMappers;
    }

    <T> List<Decoder> getDecoderForClass(String path, Tags tags, ConfigNode configNode, TypeCapture<T> klass) {
        return this.decoders.stream().filter(decoder -> decoder.canDecode(path, tags, configNode, klass)).collect(Collectors.toList());
    }

    @Override
    public <T> GResultOf<T> decodeNode(String path, Tags tags, String configNode, TypeCapture<T> klass, DecoderContext decoderContext) {
        return this.decodeNode(path, tags, new LeafNode(configNode), klass, decoderContext);
    }

    @Override
    public <T> GResultOf<T> decodeNode(String path, Tags tags, ConfigNode configNode, TypeCapture<T> klass, DecoderContext decoderContext) {
        List<Decoder> classDecoder = this.getDecoderForClass(path, tags, configNode, klass);
        classDecoder.sort(Comparator.comparingInt(v -> v.priority().ordinal()));
        if (classDecoder.isEmpty()) {
            return GResultOf.errors(new ValidationError.NoDecodersFound(klass.getName(), configNode));
        }
        if (classDecoder.size() > 1) {
            logger.log(System.Logger.Level.TRACE, "Found multiple decoders for {0}, found: {1}, using {2}: ", klass, classDecoder, classDecoder.get(0));
        }
        return classDecoder.get(0).decode(path, tags, configNode, klass, decoderContext);
    }

    @Override
    public GResultOf<ConfigNode> getNextNode(String path, String nextPath, ConfigNode configNode) {
        GResultOf<ConfigNode> result;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (PathMapper pathMapper : this.pathMappers) {
            GResultOf<List<Token>> pathGResultOf = pathMapper.map(path, nextPath, this.lexer);
            errors.addAll(pathGResultOf.getErrors());
            if (!pathGResultOf.hasResults()) continue;
            List<Token> nextTokens = pathGResultOf.results();
            result = this.configNodeService.navigateToNextNode(path, nextTokens, configNode);
            if (result.hasErrors() && errors.isEmpty()) {
                errors.addAll(result.getErrors());
            }
            if (!result.hasResults()) continue;
            return result;
        }
        result = !errors.isEmpty() ? GResultOf.errors(errors) : GResultOf.errors(new ValidationError.NoResultsFoundForNode(path, configNode.getNodeType().getType(), "decoding"));
        return result;
    }

    @Override
    public GResultOf<ConfigNode> getNextNode(String path, int nextIndex, ConfigNode configNode) {
        ArrayToken nextToken = new ArrayToken(nextIndex);
        return this.configNodeService.navigateToNextNode(path, List.of(nextToken), configNode);
    }
}

