/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class EnumDecoder<T extends Enum<T>>
extends LeafDecoder<T> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Enum";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return type.getRawType().isEnum();
    }

    @Override
    protected GResultOf<T> leafDecode(String path, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        String value = node.getValue().orElse("");
        try {
            ?[] enumConstants;
            Class<?> klass = type.getRawType();
            Method m = klass.getMethod("name", new Class[0]);
            for (Object enumConst : enumConstants = klass.getEnumConstants()) {
                Object enumName = m.invoke(enumConst, new Object[0]);
                if (!(enumName instanceof String) || !value.equalsIgnoreCase((String)enumName)) continue;
                return GResultOf.result((Enum)enumConst);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return GResultOf.errors(new ValidationError.ExceptionDecodingEnum(path, value, type.getRawType(), e));
        }
        return GResultOf.errors(new ValidationError.EnumValueNotFound(path, value, type.getRawType()));
    }

    @Override
    protected GResultOf<T> leafDecode(String path, ConfigNode node, DecoderContext decoderContext) {
        return null;
    }
}

