/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.github.gestalt.config.decoder.CollectionDecoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;

public final class ListDecoder
extends CollectionDecoder<List<?>> {
    private static final System.Logger logger = System.getLogger(ListDecoder.class.getName());
    Map<Class<?>, Supplier<List>> supplierMap = new HashMap();
    Class<?> sequencedCollection;

    public ListDecoder() {
        this.supplierMap.put(List.class, ArrayList::new);
        this.supplierMap.put(AbstractList.class, ArrayList::new);
        this.supplierMap.put(CopyOnWriteArrayList.class, CopyOnWriteArrayList::new);
        this.supplierMap.put(ArrayList.class, ArrayList::new);
        this.supplierMap.put(LinkedList.class, LinkedList::new);
        this.supplierMap.put(Stack.class, Stack::new);
        this.supplierMap.put(Vector.class, Vector::new);
        try {
            this.sequencedCollection = Class.forName("java.util.SequencedCollection");
            this.supplierMap.put(this.sequencedCollection, ArrayList::new);
        }
        catch (ClassNotFoundException e) {
            this.sequencedCollection = null;
            logger.log(System.Logger.Level.TRACE, "Unable to find class java.util.SequencedCollection, SequencedCollectionDecoder disabled");
        }
    }

    @Override
    public String name() {
        return "List";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return List.class.isAssignableFrom(type.getRawType()) && type.hasParameter() || this.sequencedCollection != null && this.sequencedCollection.equals(type.getRawType());
    }

    @Override
    protected GResultOf<List<?>> arrayDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> klass, DecoderContext decoderContext) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Supplier<List> mapSupplier = this.supplierMap.get(klass.getRawType());
        if (mapSupplier == null) {
            logger.log(System.Logger.Level.TRACE, "Unable to find supplier for " + klass.getRawType() + ", defaulting to ArrayList");
            mapSupplier = this.supplierMap.get(List.class);
        }
        List results = mapSupplier.get();
        for (int i = 0; i < node.size(); ++i) {
            Optional<ConfigNode> valueOptional = node.getIndex(i);
            if (valueOptional.isPresent()) {
                ConfigNode currentNode = valueOptional.get();
                String nextPath = PathUtil.pathForIndex(decoderContext.getDefaultLexer(), path, i);
                GResultOf<?> resultOf = decoderContext.getDecoderService().decodeNode(nextPath, tags, currentNode, klass.getFirstParameterType(), decoderContext);
                errors.addAll(resultOf.getErrors());
                if (!resultOf.hasResults()) continue;
                results.add(resultOf.results());
                continue;
            }
            errors.add(new ValidationError.ArrayMissingIndex(i));
            results.add(null);
        }
        return GResultOf.resultOf(results, errors);
    }
}

