/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class LocalDateTimeDecoder
extends LeafDecoder<LocalDateTime> {
    private DateTimeFormatter formatter;

    public LocalDateTimeDecoder() {
        this.formatter = DateTimeFormatter.ISO_DATE_TIME;
    }

    public LocalDateTimeDecoder(String formatter) {
        this.formatter = formatter != null && !formatter.isEmpty() ? DateTimeFormatter.ofPattern(formatter) : DateTimeFormatter.ISO_DATE_TIME;
    }

    @Override
    public void applyConfig(GestaltConfig config) {
        if (config.getDateDecoderFormat() != null && this.formatter.equals(DateTimeFormatter.ISO_DATE_TIME)) {
            this.formatter = config.getDateDecoderFormat();
        }
    }

    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "LocalDateTime";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return LocalDateTime.class.isAssignableFrom(type.getRawType());
    }

    @Override
    protected GResultOf<LocalDateTime> leafDecode(String path, ConfigNode node, DecoderContext decoderContext) {
        GResultOf<LocalDateTime> results;
        String value = node.getValue().orElse("");
        try {
            results = GResultOf.result(LocalDateTime.parse(value, this.formatter));
        }
        catch (DateTimeParseException e) {
            results = GResultOf.errors(new ValidationError.ErrorDecodingException(path, node, this.name(), e.getMessage(), decoderContext));
        }
        return results;
    }
}

