/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.node.NodeType;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ClassUtils;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.PathUtil;

public final class MapDecoder
implements Decoder<Map<?, ?>> {
    private static final System.Logger logger = System.getLogger(MapDecoder.class.getName());
    Class<?> sequencedMap;
    Map<Class<?>, Supplier<Map>> supplierMap = new HashMap();

    public MapDecoder() {
        this.supplierMap.put(Map.class, HashMap::new);
        this.supplierMap.put(HashMap.class, HashMap::new);
        this.supplierMap.put(TreeMap.class, TreeMap::new);
        this.supplierMap.put(LinkedHashMap.class, LinkedHashMap::new);
        try {
            this.sequencedMap = Class.forName("java.util.SequencedMap");
            this.supplierMap.put(this.sequencedMap, LinkedHashMap::new);
        }
        catch (ClassNotFoundException e) {
            this.sequencedMap = null;
            logger.log(System.Logger.Level.TRACE, "Unable to find class java.util.SequencedMap, SequencedMapDecoder disabled");
        }
    }

    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Map";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return Map.class.isAssignableFrom(type.getRawType()) && type.hasParameter() && node != null && (node.getNodeType() == NodeType.MAP || node.getNodeType() == NodeType.LEAF);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GResultOf<Map<?, ?>> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        void var6_34;
        if (node instanceof LeafNode) {
            Optional<String> optionalValue = node.getValue();
            if (optionalValue.isPresent()) {
                String[] mapKeyValue;
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                HashMap<String, ConfigNode> mapResult = new HashMap<String, ConfigNode>();
                String value = optionalValue.get();
                for (String entry : mapKeyValue = value.split("(?<!\\\\),")) {
                    if (entry.isBlank()) continue;
                    String[] keyValuePair = entry.split("(?<!\\\\)=", 2);
                    if (keyValuePair.length != 2) {
                        errors.add(new ValidationError.MapEntryInvalid(path, entry, node, decoderContext));
                        continue;
                    }
                    String mapKey = keyValuePair[0].trim().replace("\\,", ",").replace("\\=", "=");
                    String mapValue = keyValuePair[1].trim().replace("\\,", ",").replace("\\=", "=");
                    mapResult.put(mapKey, new LeafNode(mapValue));
                }
                if (errors.isEmpty()) {
                    GResultOf<Map<?, ?>> gResultOf = this.decode(path, tags, new MapNode((Map<String, ConfigNode>)mapResult), type, decoderContext);
                    return var6_34;
                } else {
                    GResultOf gResultOf = GResultOf.errors(errors);
                }
                return var6_34;
            } else {
                GResultOf gResultOf = GResultOf.errors(new ValidationError.DecodingLeafMissingValue(path, this.name()));
            }
            return var6_34;
        } else {
            if (!(node instanceof MapNode)) return GResultOf.errors(new ValidationError.DecodingExpectedMapNodeType(path, node));
            MapNode mapNode = (MapNode)node;
            List<TypeCapture<?>> genericInterfaces = type.getParameterTypes();
            if (genericInterfaces == null || genericInterfaces.size() != 2) {
                GResultOf gResultOf = GResultOf.errors(new ValidationError.DecodingExpectedMapNodeType(path, genericInterfaces, node));
                return var6_34;
            } else {
                void var13_21;
                TypeCapture<?> keyType = genericInterfaces.get(0);
                TypeCapture<?> valueType = genericInterfaces.get(1);
                Supplier<Map> mapSupplier = this.supplierMap.get(type.getRawType());
                if (mapSupplier == null) {
                    logger.log(System.Logger.Level.TRACE, "Unable to find supplier for " + type.getRawType() + ", defaulting to HashMap");
                    mapSupplier = this.supplierMap.get(Map.class);
                }
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                Stream stream = mapNode.getMapNode().entrySet().stream();
                if (ClassUtils.isPrimitiveOrWrapper(valueType.getRawType())) {
                    Stream stream2 = stream.flatMap(it -> this.convertMapToStream((String)it.getKey(), (Map.Entry<String, ConfigNode>)it, decoderContext));
                }
                Map map = var13_21.map(it -> {
                    String key = (String)it.getKey();
                    if (key == null) {
                        errors.add(new ValidationError.DecodersMapKeyNull(path));
                        return null;
                    }
                    String nextPath = PathUtil.pathForKey(decoderContext.getDefaultLexer(), path, key);
                    GResultOf keyValidate = decoderContext.getDecoderService().decodeNode(nextPath, tags, new LeafNode(key), keyType, decoderContext);
                    GResultOf valueValidate = decoderContext.getDecoderService().decodeNode(nextPath, tags, (ConfigNode)it.getValue(), valueType, decoderContext);
                    errors.addAll(keyValidate.getErrors());
                    errors.addAll(valueValidate.getErrors());
                    if (!keyValidate.hasResults()) {
                        errors.add(new ValidationError.DecodersMapKeyNull(nextPath));
                    }
                    if (!valueValidate.hasResults()) {
                        errors.add(new ValidationError.DecodersMapValueNull(nextPath));
                    }
                    if (keyValidate.hasResults()) {
                        return new Pair(keyValidate.results(), valueValidate.results());
                    }
                    return null;
                }).filter(Objects::nonNull).collect(mapSupplier, (m, v) -> m.put(v.getFirst(), v.getSecond()), Map::putAll);
                return GResultOf.resultOf(map, errors);
            }
        }
    }

    private Stream<Map.Entry<String, ConfigNode>> convertMapToStream(String path, Map.Entry<String, ConfigNode> entry, DecoderContext decoderContext) {
        SentenceLexer lexer = decoderContext.getDefaultLexer();
        if (path == null || entry.getValue() == null) {
            return Stream.of(entry);
        }
        if (entry.getValue() instanceof MapNode) {
            MapNode node = (MapNode)entry.getValue();
            return node.getMapNode().entrySet().stream().flatMap(it -> this.convertMapToStream(PathUtil.pathForKey(lexer, path, (String)it.getKey()), (Map.Entry<String, ConfigNode>)it, decoderContext));
        }
        if (entry.getValue() instanceof ArrayNode) {
            ArrayNode node = (ArrayNode)entry.getValue();
            Stream<Map.Entry<String, ConfigNode>> stream = Stream.of(new Map.Entry[0]);
            List<ConfigNode> nodes = node.getArray();
            for (int i = 0; i < nodes.size(); ++i) {
                stream = Stream.concat(stream, this.convertMapToStream(PathUtil.pathForIndex(lexer, path, i), Map.entry(PathUtil.forIndex(lexer, i), nodes.get(i)), decoderContext));
            }
            return stream;
        }
        if (entry.getValue() instanceof LeafNode) {
            return Stream.of(Map.entry(path, entry.getValue()));
        }
        return Stream.of(new Map.Entry[0]);
    }
}

