/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.github.gestalt.config.annotations.Config;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ClassUtils;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;

public final class ObjectDecoder
implements Decoder<Object> {
    private static final System.Logger logger = System.getLogger(ObjectDecoder.class.getName());
    private final Set<Class<?>> ignoreTypes = this.getIgnoreTypes();

    private String getMethodName(Field field) {
        String methodName = field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class) ? "is" + field.getName() : "get" + field.getName();
        return methodName;
    }

    @Override
    public Priority priority() {
        return Priority.VERY_LOW;
    }

    @Override
    public String name() {
        return "Object";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return !type.getRawType().isPrimitive() && !type.isArray() && !type.isEnum() && !type.hasParameter() && !type.isInterface() && !this.ignoreTypes.contains(type.getRawType());
    }

    private Set<Class<?>> getIgnoreTypes() {
        return new HashSet(List.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class, Void.class));
    }

    @Override
    public GResultOf<Object> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        if (!(node instanceof MapNode)) {
            List<TypeCapture<?>> genericInterfaces = type.getParameterTypes();
            return GResultOf.errors(new ValidationError.DecodingExpectedMapNodeType(path, genericInterfaces, node));
        }
        Class<?> klass = type.getRawType();
        DecoderService decoderSrv = decoderContext.getDecoderService();
        try {
            Constructor<?> constructor = klass.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(constructor.getModifiers())) {
                return GResultOf.errors(new ValidationError.ConstructorNotPublic(path, klass.getName()));
            }
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            Object obj = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            List<Field> classFields = this.getClassFields(klass);
            for (Field field : classFields) {
                String methodName;
                Optional<Method> method;
                int modifiers = field.getModifiers();
                String fieldName = field.getName();
                boolean foundValue = false;
                if (Modifier.isStatic(modifiers)) {
                    logger.log(System.Logger.Level.INFO, "Ignoring static field for class: " + klass.getName() + " field " + fieldName);
                    continue;
                }
                Type fieldClass = field.getGenericType();
                TypeCapture fieldType = TypeCapture.of(fieldClass);
                String name = this.getFieldAnnotationValue(klass, field, fieldName, fieldClass, Config::path);
                name = name.isEmpty() ? fieldName : name;
                String nextPath = PathUtil.pathForKey(decoderContext.getDefaultLexer(), path, name);
                GResultOf<ConfigNode> configNode = decoderSrv.getNextNode(nextPath, name, node);
                errors.addAll(configNode.getErrorsNotLevel(ValidationLevel.MISSING_VALUE));
                if (configNode.hasResults()) {
                    GResultOf decodeResultOf = decoderSrv.decodeNode(nextPath, tags, configNode.results(), fieldType, decoderContext);
                    errors.addAll(decodeResultOf.getErrors());
                    if (decodeResultOf.hasResults()) {
                        foundValue = true;
                        this.setField(obj, field, klass, decodeResultOf.results());
                    }
                } else {
                    String defaultValue = this.getFieldAnnotationValue(klass, field, fieldName, fieldClass, Config::defaultVal);
                    if (!defaultValue.isEmpty()) {
                        GResultOf defaultGResultOf = decoderSrv.decodeNode(nextPath, tags, new LeafNode(defaultValue), fieldType, decoderContext);
                        errors.addAll(defaultGResultOf.getErrors());
                        if (defaultGResultOf.hasResults()) {
                            foundValue = true;
                            this.setField(obj, field, klass, defaultGResultOf.results());
                            errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), decoderContext));
                        }
                    } else {
                        GResultOf decodedResults = decoderSrv.decodeNode(nextPath, tags, configNode.results(), fieldType, decoderContext);
                        if (decodedResults.hasResults()) {
                            errors.addAll(decodedResults.getErrorsNotLevel(ValidationLevel.MISSING_OPTIONAL_VALUE));
                            errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), klass.getSimpleName(), decoderContext));
                            foundValue = true;
                            this.setField(obj, field, klass, decodedResults.results());
                        }
                    }
                }
                if (foundValue) continue;
                boolean initialized = this.fieldHasInitializedValue(obj, field, klass);
                if (initialized) {
                    errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), klass.getSimpleName(), decoderContext));
                    continue;
                }
                Annotation[] fieldAnnotations = field.getAnnotations();
                boolean isNullable = ObjectDecoder.isNullableAnnotation(fieldAnnotations);
                if (!isNullable && (method = this.getMethod(klass, methodName = this.getMethodName(field)).or(() -> this.getMethod(klass, fieldName))).isPresent()) {
                    Annotation[] methodAnnotations = method.get().getAnnotations();
                    isNullable = ObjectDecoder.isNullableAnnotation(methodAnnotations);
                }
                if (!isNullable) {
                    errors.add(new ValidationError.NoResultsFoundForNode(nextPath, klass.getSimpleName(), "object decoding"));
                    continue;
                }
                errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), klass.getSimpleName(), decoderContext));
            }
            return GResultOf.resultOf(obj, errors);
        }
        catch (NoSuchMethodException e) {
            return GResultOf.errors(new ValidationError.NoDefaultConstructor(path, klass.getName()));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            return GResultOf.errors(new ValidationError.ConstructorNotPublic(path, klass.getName()));
        }
    }

    private static boolean isNullableAnnotation(Annotation[] fieldAnnotations) {
        return Arrays.stream(fieldAnnotations).anyMatch(it -> it.annotationType().getName().toLowerCase(Locale.getDefault()).contains("nullable"));
    }

    private boolean fieldHasInitializedValue(Object obj, Field field, Class<?> klass) throws IllegalAccessException {
        String methodName = this.getMethodName(field);
        Object fieldValue = null;
        Optional<Method> method = this.getMethod(klass, methodName);
        if (method.isPresent()) {
            try {
                fieldValue = method.get().invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException e) {
                logger.log(System.Logger.Level.WARNING, "Failed to get value calling method " + methodName + ", on class " + klass.getSimpleName() + ", for field " + field.getName());
            }
        }
        if (fieldValue == null) {
            field.setAccessible(true);
            fieldValue = field.get(obj);
        }
        if (field.getType().isPrimitive()) {
            if (Byte.TYPE.isAssignableFrom(fieldValue.getClass()) || Byte.class.isAssignableFrom(fieldValue.getClass())) {
                return (Byte)fieldValue != 0;
            }
            if (Short.TYPE.isAssignableFrom(fieldValue.getClass()) || Short.class.isAssignableFrom(fieldValue.getClass())) {
                return (Short)fieldValue != 0;
            }
            if (Integer.TYPE.isAssignableFrom(fieldValue.getClass()) || Integer.class.isAssignableFrom(fieldValue.getClass())) {
                return (Integer)fieldValue != 0;
            }
            if (Long.TYPE.isAssignableFrom(fieldValue.getClass()) || Long.class.isAssignableFrom(fieldValue.getClass())) {
                return (Long)fieldValue != 0L;
            }
            if (Float.TYPE.isAssignableFrom(fieldValue.getClass()) || Float.class.isAssignableFrom(fieldValue.getClass())) {
                return ((Float)fieldValue).floatValue() != 0.0f;
            }
            if (Double.TYPE.isAssignableFrom(fieldValue.getClass()) || Double.class.isAssignableFrom(fieldValue.getClass())) {
                return (Double)fieldValue != 0.0;
            }
            if (Boolean.TYPE.isAssignableFrom(fieldValue.getClass()) || Boolean.class.isAssignableFrom(fieldValue.getClass())) {
                return (Boolean)fieldValue;
            }
            if (Character.TYPE.isAssignableFrom(fieldValue.getClass()) || Character.class.isAssignableFrom(fieldValue.getClass())) {
                return ((Character)fieldValue).charValue() != '\u0000';
            }
            return false;
        }
        return fieldValue != null;
    }

    private String getFieldAnnotationValue(Class<?> klass, Field field, String fieldName, Type fieldClass, Function<Config, String> get) {
        String value = "";
        Optional<Config> configAnnotation = Optional.ofNullable(field.getAnnotation(Config.class));
        if (configAnnotation.isPresent() && get.apply(configAnnotation.get()) != null && !get.apply(configAnnotation.get()).isEmpty()) {
            value = get.apply(configAnnotation.get());
        } else {
            configAnnotation = this.findMethodConfig(klass, fieldName, fieldClass, get);
            if (configAnnotation.isPresent() && get.apply(configAnnotation.get()) != null && !get.apply(configAnnotation.get()).isEmpty()) {
                value = get.apply(configAnnotation.get());
            }
        }
        return value;
    }

    private Optional<Config> findMethodConfig(Class<?> klass, String fieldName, Type fieldClass, Function<Config, String> get) {
        String methodName = fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Boolean.TYPE) ? "is" + fieldName : "get" + fieldName;
        Optional<Config> configAnnotation = this.getMethodAnnotation(klass, methodName, get).or(() -> this.getMethodAnnotation(klass, fieldName, get));
        return configAnnotation;
    }

    private Optional<Config> getMethodAnnotation(Class<?> klass, String methodName, Function<Config, String> get) {
        Config methodConfigAnnotation;
        Config result = null;
        Optional<Method> method = this.getMethod(klass, methodName);
        if (method.isPresent() && (methodConfigAnnotation = method.get().getAnnotation(Config.class)) != null && get.apply(methodConfigAnnotation) != null && !get.apply(methodConfigAnnotation).isEmpty()) {
            result = method.get().getAnnotation(Config.class);
        }
        return Optional.ofNullable(result);
    }

    private Optional<Method> getMethod(Class<?> klass, String methodName) {
        return Arrays.stream(klass.getMethods()).filter(it -> it.getName().equalsIgnoreCase(methodName)).findFirst();
    }

    private void setField(Object obj, Field field, Class<?> klass, Object value) throws IllegalAccessException {
        String methodName = "set" + field.getName();
        Optional<Method> setMethod = this.getMethod(klass, methodName);
        if (setMethod.isPresent() && setMethod.get().getParameterCount() == 1 && ClassUtils.isAssignable(setMethod.get().getParameters()[0].getType(), value.getClass())) {
            try {
                setMethod.get().invoke(obj, value);
            }
            catch (InvocationTargetException e) {
                logger.log(System.Logger.Level.WARNING, "unable to set field " + field.getName() + " using method " + methodName + ", on class " + klass.getSimpleName() + ", for val: " + value + ", setting field directly");
                field.setAccessible(true);
                field.set(obj, value);
            }
        } else {
            field.setAccessible(true);
            field.set(obj, value);
        }
    }

    private List<Field> getClassFields(Class<?> klass) {
        ArrayList<Field> classFields = new ArrayList<Field>();
        for (Class<?> currentClass = klass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fields = currentClass.getDeclaredFields();
            classFields.addAll(List.of(fields));
        }
        return classFields;
    }
}

